/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.internal.widgets;

import java.util.Hashtable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.internal.widgets.Locator;
import org.eclipse.ui.forms.internal.widgets.TextSegment;

public class HyperlinkSegment
extends TextSegment {
    private String href;
    private static final String LINK_FG = "c.___link_fg";
    private HyperlinkSettings settings;

    public HyperlinkSegment(String text, HyperlinkSettings settings, String fontId) {
        super(text, fontId);
        this.settings = settings;
        this.underline = settings.getHyperlinkUnderlineMode() == 3;
    }

    public String getHref() {
        return this.href;
    }

    void setHref(String href) {
        this.href = href;
    }

    public void paint(GC gc, int width, Locator locator, Hashtable resourceTable, boolean selected) {
        resourceTable.put(LINK_FG, this.settings.getForeground());
        this.setColorId(LINK_FG);
        super.paint(gc, width, locator, resourceTable, selected);
    }

    public void repaint(GC gc, boolean hover) {
        FontMetrics fm = gc.getFontMetrics();
        int lineHeight = fm.getHeight();
        int descent = fm.getDescent();
        boolean rolloverMode = this.settings.getHyperlinkUnderlineMode() == 2;
        int i = 0;
        while (i < this.areaRectangles.size()) {
            TextSegment.AreaRectangle areaRectangle = (TextSegment.AreaRectangle)this.areaRectangles.get(i);
            Rectangle rect = areaRectangle.rect;
            String text = areaRectangle.getText();
            Point extent = gc.textExtent(text);
            int textX = rect.x + 1;
            gc.drawString(text, textX, rect.y, true);
            if (this.underline || hover || rolloverMode) {
                int lineY = rect.y + lineHeight - descent + 1;
                Color saved = null;
                if (rolloverMode && !hover) {
                    saved = gc.getForeground();
                    gc.setForeground(gc.getBackground());
                }
                gc.drawLine(textX, lineY, textX + extent.x, lineY);
                if (saved != null) {
                    gc.setForeground(saved);
                }
            }
            ++i;
        }
    }
}

