/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import java.util.Vector;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.ExpansionListener;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.internal.widgets.FormUtil;
import org.eclipse.ui.forms.internal.widgets.FormsResources;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.forms.widgets.ToggleHyperlink;
import org.eclipse.ui.forms.widgets.TreeNode;
import org.eclipse.ui.forms.widgets.Twistie;

public class ExpandableComposite
extends Composite {
    public static final int TWISTIE = 2;
    public static final int TREE_NODE = 4;
    public static final int FOCUS_TITLE = 8;
    public static final int CLIENT_INDENT = 16;
    public static final int COMPACT = 32;
    public static final int EXPANDED = 64;
    public int marginWidth = 0;
    public int marginHeight = 0;
    private int GAP = 4;
    private int VSPACE = 3;
    private int SEPARATOR_HEIGHT = 2;
    private int expansionStyle = 74;
    private boolean expanded;
    private Control client;
    private Vector listeners;
    protected ToggleHyperlink toggle;
    protected Control textLabel;

    public ExpandableComposite(Composite parent, int style) {
        this(parent, style, 2);
    }

    public ExpandableComposite(Composite parent, int style, int expansionStyle) {
        super(parent, style);
        this.expansionStyle = expansionStyle;
        super.setLayout((Layout)new ExpandableLayout());
        this.listeners = new Vector();
        if ((expansionStyle & 2) != 0) {
            this.toggle = new Twistie(this, 0);
        } else if ((expansionStyle & 4) != 0) {
            this.toggle = new TreeNode(this, 0);
        } else {
            this.expanded = true;
        }
        if ((expansionStyle & 0x40) != 0) {
            this.expanded = true;
        }
        if (this.toggle != null) {
            this.toggle.setExpanded(this.expanded);
            this.toggle.addHyperlinkListener(new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    ExpandableComposite.this.toggleState();
                }
            });
        }
        if ((expansionStyle & 8) != 0) {
            Hyperlink link = new Hyperlink(this, 64);
            link.addHyperlinkListener(new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    ExpandableComposite.this.toggle.setExpanded(!ExpandableComposite.this.toggle.isExpanded());
                    ExpandableComposite.this.toggleState();
                }
            });
            this.textLabel = link;
        } else {
            final Label label = new Label((Composite)this, 64);
            if (!this.isFixedStyle()) {
                label.setCursor(FormsResources.getHandCursor());
                label.addListener(3, new Listener(){

                    public void handleEvent(Event e) {
                        if (ExpandableComposite.this.toggle != null) {
                            ExpandableComposite.this.toggle.setFocus();
                        }
                    }
                });
                label.addListener(4, new Listener(){

                    public void handleEvent(Event e) {
                        label.setCursor(FormsResources.getBusyCursor());
                        ExpandableComposite.this.toggle.setExpanded(!ExpandableComposite.this.toggle.isExpanded());
                        ExpandableComposite.this.toggleState();
                        label.setCursor(FormsResources.getHandCursor());
                    }
                });
            }
            this.textLabel = label;
        }
    }

    public final void setLayout(Layout layout) {
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.textLabel.setBackground(bg);
        if (this.toggle != null) {
            this.toggle.setBackground(bg);
        }
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        this.textLabel.setForeground(fg);
        if (this.toggle != null) {
            this.toggle.setForeground(fg);
        }
    }

    public void setToggleColor(Color c) {
        if (this.toggle != null) {
            this.toggle.setDecorationColor(c);
        }
    }

    public void setActiveToggleColor(Color c) {
        if (this.toggle != null) {
            this.toggle.setHoverDecorationColor(c);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.textLabel.setFont(font);
        if (this.toggle != null) {
            this.toggle.setFont(font);
        }
    }

    public void setClient(Control client) {
        Assert.isTrue((client != null && client.getParent().equals((Object)this) ? 1 : 0) != 0);
        this.client = client;
    }

    public Control getClient() {
        return this.client;
    }

    public void setText(String title) {
        if (this.textLabel instanceof Label) {
            ((Label)this.textLabel).setText(title);
        } else {
            ((Hyperlink)this.textLabel).setText(title);
        }
    }

    public String getText() {
        if (this.textLabel instanceof Label) {
            return ((Label)this.textLabel).getText();
        }
        return ((Hyperlink)this.textLabel).getText();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public int getExpansionStyle() {
        return this.expansionStyle;
    }

    public void setExpanded(boolean expanded) {
        this.internalSetExpanded(expanded);
        if (this.toggle != null) {
            this.toggle.setExpanded(expanded);
        }
    }

    protected void internalSetExpanded(boolean expanded) {
        if (this.expanded != expanded) {
            this.expanded = expanded;
            if (this.getDescriptionControl() != null) {
                this.getDescriptionControl().setVisible(expanded);
            }
            if (this.client != null) {
                this.client.setVisible(expanded);
            }
            this.layout();
        }
    }

    public void addExpansionListener(ExpansionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeExpansionListener(ExpansionListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private void toggleState() {
        boolean newState = !this.isExpanded();
        this.fireExpanding(newState, true);
        this.internalSetExpanded(!this.isExpanded());
        this.fireExpanding(newState, false);
    }

    private void fireExpanding(boolean state, boolean before) {
        int size = this.listeners.size();
        if (size == 0) {
            return;
        }
        ExpansionEvent e = new ExpansionEvent((Object)this, state);
        int i = 0;
        while (i < size) {
            ExpansionListener listener = (ExpansionListener)this.listeners.get(i);
            if (before) {
                listener.expansionStateChanging(e);
            } else {
                listener.expansionStateChanged(e);
            }
            ++i;
        }
    }

    protected Control getDescriptionControl() {
        return null;
    }

    protected Control getSeparatorControl() {
        return null;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        ExpandableLayout layout = (ExpandableLayout)this.getLayout();
        Point size = wHint == -1 || hHint == -1 ? layout.computeSize(this, wHint, hHint, changed) : new Point(wHint, hHint);
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    protected boolean isFixedStyle() {
        return (this.expansionStyle & 2) == 0 && (this.expansionStyle & 4) == 0;
    }

    private class ExpandableLayout
    extends Layout
    implements ILayoutExtension {
        ExpandableLayout() {
        }

        protected void layout(Composite parent, boolean changed) {
            Rectangle clientArea = parent.getClientArea();
            int x = ExpandableComposite.this.marginWidth;
            int y = ExpandableComposite.this.marginHeight;
            Point tsize = null;
            if (ExpandableComposite.this.toggle != null) {
                tsize = ExpandableComposite.this.toggle.computeSize(-1, -1, changed);
            }
            int twidth = clientArea.width - ExpandableComposite.this.marginWidth - ExpandableComposite.this.marginWidth;
            if (tsize != null) {
                twidth -= tsize.x + ExpandableComposite.this.GAP;
            }
            Point size = ExpandableComposite.this.textLabel.computeSize(twidth, -1, changed);
            if (ExpandableComposite.this.textLabel instanceof Label) {
                Point defSize = ExpandableComposite.this.textLabel.computeSize(-1, -1, changed);
                if (defSize.y == size.y) {
                    size.x = Math.min(defSize.x, size.x);
                }
            }
            if (ExpandableComposite.this.toggle != null) {
                GC gc = new GC((Drawable)ExpandableComposite.this);
                gc.setFont(ExpandableComposite.this.getFont());
                FontMetrics fm = gc.getFontMetrics();
                int fontHeight = fm.getHeight();
                gc.dispose();
                int ty = fontHeight / 2 - tsize.y / 2 + 1;
                ty = Math.max(ty, 0);
                ExpandableComposite.this.toggle.setLocation(x, ty);
                ExpandableComposite.this.toggle.setSize(tsize);
                x += tsize.x + ExpandableComposite.this.GAP;
            }
            ExpandableComposite.this.textLabel.setBounds(x, y, size.x, size.y);
            y += size.y;
            if (ExpandableComposite.this.getSeparatorControl() != null) {
                ExpandableComposite.this.getSeparatorControl().setBounds(ExpandableComposite.this.marginWidth, y += ExpandableComposite.this.VSPACE, clientArea.width - ExpandableComposite.this.marginWidth - ExpandableComposite.this.marginWidth, ExpandableComposite.this.SEPARATOR_HEIGHT);
                y += ExpandableComposite.this.SEPARATOR_HEIGHT;
                if (ExpandableComposite.this.expanded) {
                    y += ExpandableComposite.this.VSPACE;
                }
            }
            if (ExpandableComposite.this.expanded) {
                int areaWidth = clientArea.width - ExpandableComposite.this.marginWidth - ExpandableComposite.this.marginWidth;
                int cx = ExpandableComposite.this.marginWidth;
                if ((ExpandableComposite.this.expansionStyle & 0x10) != 0) {
                    cx = x;
                    areaWidth -= x;
                }
                if (ExpandableComposite.this.client != null) {
                    Point dsize = null;
                    Control desc = ExpandableComposite.this.getDescriptionControl();
                    if (desc != null) {
                        dsize = desc.computeSize(areaWidth, -1, changed);
                        desc.setBounds(cx, y, dsize.x, dsize.y);
                        y += dsize.y + ExpandableComposite.this.VSPACE;
                    }
                    int cwidth = clientArea.width - ExpandableComposite.this.marginWidth - ExpandableComposite.this.marginWidth - cx;
                    int cheight = clientArea.height - ExpandableComposite.this.marginHeight - ExpandableComposite.this.marginHeight - y;
                    ExpandableComposite.this.client.setBounds(cx, y, cwidth, cheight);
                }
            }
        }

        protected Point computeSize(Composite parent, int wHint, int hHint, boolean changed) {
            int innerwHint;
            int width = 0;
            int height = 0;
            Point tsize = null;
            int twidth = 0;
            if (ExpandableComposite.this.toggle != null) {
                tsize = ExpandableComposite.this.toggle.computeSize(-1, -1, changed);
                twidth = tsize.x + ExpandableComposite.this.GAP;
            }
            if ((innerwHint = wHint) != -1) {
                innerwHint -= twidth;
            }
            Point size = ExpandableComposite.this.textLabel.computeSize(innerwHint, -1, changed);
            if (ExpandableComposite.this.textLabel instanceof Label) {
                Point defSize = ExpandableComposite.this.textLabel.computeSize(-1, -1, changed);
                if (defSize.y == size.y) {
                    size.x = Math.min(defSize.x, size.x);
                }
            }
            width = size.x;
            height = size.y;
            if (ExpandableComposite.this.getSeparatorControl() != null) {
                height += ExpandableComposite.this.VSPACE + ExpandableComposite.this.SEPARATOR_HEIGHT;
                if (ExpandableComposite.this.expanded && ExpandableComposite.this.client != null) {
                    height += ExpandableComposite.this.VSPACE;
                }
            }
            if ((ExpandableComposite.this.expanded || (ExpandableComposite.this.expansionStyle & 0x20) == 0) && ExpandableComposite.this.client != null) {
                int cwHint = wHint;
                if ((ExpandableComposite.this.expansionStyle & 0x10) != 0) {
                    cwHint = innerwHint;
                }
                Point dsize = null;
                Point csize = ExpandableComposite.this.client.computeSize(FormUtil.getWidthHint(cwHint, ExpandableComposite.this.client), -1, changed);
                if (ExpandableComposite.this.getDescriptionControl() != null) {
                    int dwHint = cwHint;
                    if (dwHint == -1) {
                        dwHint = csize.x;
                        if ((ExpandableComposite.this.expansionStyle & 0x10) != 0) {
                            dwHint -= twidth;
                        }
                    }
                    dsize = ExpandableComposite.this.getDescriptionControl().computeSize(dwHint, -1, changed);
                }
                if (dsize != null) {
                    if ((ExpandableComposite.this.expansionStyle & 0x10) != 0) {
                        dsize.x -= twidth;
                    }
                    width = Math.max(width, dsize.x);
                    if (ExpandableComposite.this.expanded) {
                        height += dsize.y + ExpandableComposite.this.VSPACE;
                    }
                }
                if ((ExpandableComposite.this.expansionStyle & 0x10) != 0) {
                    csize.x -= twidth;
                }
                width = Math.max(width, csize.x);
                if (ExpandableComposite.this.expanded) {
                    height += csize.y;
                }
            }
            if (ExpandableComposite.this.toggle != null) {
                height = height - size.y + Math.max(size.y, tsize.y);
                width += twidth;
            }
            return new Point(width + ExpandableComposite.this.marginWidth + ExpandableComposite.this.marginWidth, height + ExpandableComposite.this.marginHeight + ExpandableComposite.this.marginHeight);
        }

        public int computeMinimumWidth(Composite parent, boolean changed) {
            int width = 0;
            Point size = ExpandableComposite.this.textLabel.computeSize(5, -1, changed);
            width = size.x;
            if ((ExpandableComposite.this.expanded || (ExpandableComposite.this.expansionStyle & 0x20) == 0) && ExpandableComposite.this.client != null) {
                Point dsize = null;
                if (ExpandableComposite.this.getDescriptionControl() != null) {
                    dsize = ExpandableComposite.this.getDescriptionControl().computeSize(5, -1, changed);
                    width = Math.max(width, dsize.x);
                }
                int cwidth = FormUtil.computeMinimumWidth(ExpandableComposite.this.client, changed);
                width = Math.max(width, cwidth);
            }
            if (ExpandableComposite.this.toggle != null) {
                Point tsize = ExpandableComposite.this.toggle.computeSize(-1, -1, changed);
                width += tsize.x + ExpandableComposite.this.GAP;
            }
            return width + ExpandableComposite.this.marginWidth + ExpandableComposite.this.marginWidth;
        }

        public int computeMaximumWidth(Composite parent, boolean changed) {
            int width = 0;
            Point size = ExpandableComposite.this.textLabel.computeSize(-1, -1, changed);
            width = size.x;
            if ((ExpandableComposite.this.expanded || (ExpandableComposite.this.expansionStyle & 0x20) == 0) && ExpandableComposite.this.client != null) {
                Point dsize = null;
                if (ExpandableComposite.this.getDescriptionControl() != null) {
                    dsize = ExpandableComposite.this.getDescriptionControl().computeSize(-1, -1, changed);
                    width = Math.max(width, dsize.x);
                }
                int cwidth = FormUtil.computeMaximumWidth(ExpandableComposite.this.client, changed);
                width = Math.max(width, cwidth);
            }
            if (ExpandableComposite.this.toggle != null) {
                Point tsize = ExpandableComposite.this.toggle.computeSize(-1, -1, changed);
                width += tsize.x + ExpandableComposite.this.GAP;
            }
            return width + ExpandableComposite.this.marginWidth + ExpandableComposite.this.marginWidth;
        }
    }
}

