/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class ImageHyperlink
extends Hyperlink {
    public int textSpacing = 5;
    private Image image;
    private Image hoverImage;
    private Image activeImage;
    private int state;
    private static final int HOVER = 2;
    private static final int ACTIVE = 4;

    public ImageHyperlink(Composite parent, int style) {
        super(parent, style);
    }

    protected void paintHyperlink(GC gc) {
        Rectangle clientArea = this.getClientArea();
        Image image = null;
        if ((this.state & 4) != 0) {
            image = this.activeImage;
        } else if ((this.state & 2) != 0) {
            image = this.hoverImage;
        }
        if (image == null) {
            image = this.image;
        }
        if (image == null) {
            return;
        }
        Rectangle ibounds = image.getBounds();
        Point maxsize = this.computeMaxImageSize();
        int x = this.marginWidth + maxsize.x / 2 - ibounds.width / 2;
        int y = this.marginHeight + maxsize.y / 2 - ibounds.height / 2;
        gc.drawImage(image, x, y);
        if (this.getText() != null) {
            int textWidth = clientArea.width - maxsize.x - this.textSpacing - this.marginWidth - this.marginWidth;
            int textX = this.marginWidth + maxsize.x + this.textSpacing;
            Point textSize = this.computeTextSize(textWidth, -1);
            textWidth = textSize.x;
            int slotHeight = clientArea.height - this.marginHeight - this.marginHeight;
            int textHeight = textSize.y;
            int textY = (this.getStyle() & 0x400) != 0 ? this.marginHeight + slotHeight - textHeight : ((this.getStyle() & 0x1000000) != 0 ? this.marginHeight + slotHeight / 2 - textHeight / 2 : this.marginHeight);
            this.paintText(gc, new Rectangle(textX, textY, textWidth, textHeight));
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point isize = this.computeMaxImageSize();
        Point textSize = null;
        if (this.getText() != null) {
            int innerWHint = wHint;
            if (wHint != -1) {
                innerWHint = wHint - 2 * this.marginWidth;
            }
            textSize = super.computeSize(innerWHint, hHint, changed);
        }
        int width = isize.x;
        int height = isize.y;
        if (textSize != null) {
            width += this.textSpacing;
            width += textSize.x;
            height = Math.max(height, textSize.y);
        }
        return new Point(width += 2 * this.marginWidth, height += 2 * this.marginHeight);
    }

    protected void handleEnter() {
        this.state = 2;
        super.handleEnter();
    }

    protected void handleExit() {
        this.state = 0;
        super.handleExit();
    }

    protected void handleActivate() {
        this.state &= 4;
        this.redraw();
        super.handleActivate();
        this.state &= 0xFFFFFFFB;
        this.redraw();
    }

    public Image getActiveImage() {
        return this.activeImage;
    }

    public void setActiveImage(Image activeImage) {
        this.activeImage = activeImage;
    }

    public Image getHoverImage() {
        return this.hoverImage;
    }

    public void setHoverImage(Image hoverImage) {
        this.hoverImage = hoverImage;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    private Point computeMaxImageSize() {
        int x = 0;
        int y = 0;
        if (this.image != null) {
            x = Math.max(this.image.getBounds().width, x);
            y = Math.max(this.image.getBounds().height, y);
        }
        if (this.hoverImage != null) {
            x = Math.max(this.hoverImage.getBounds().width, x);
            y = Math.max(this.hoverImage.getBounds().height, y);
        }
        if (this.activeImage != null) {
            x = Math.max(this.activeImage.getBounds().width, x);
            y = Math.max(this.activeImage.getBounds().height, y);
        }
        return new Point(x, y);
    }
}

