/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.resources;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceManager {
    private static Hashtable m_resources = new Hashtable();
    private int m_refreshCounter;
    private static int m_staticRefreshCounter = 0;
    private ResourceBundle m_bundle;
    private String m_bundleName;

    private ResourceManager(String resourceName) {
        String className = this.getClass().getName();
        int pos = className.lastIndexOf(46);
        this.m_bundleName = pos > 0 ? className.substring(0, pos + 1) : "";
        this.m_bundleName = this.m_bundleName + resourceName;
        this.refreshBundle();
    }

    private void refreshBundle() {
        try {
            this.m_bundle = ResourceBundle.getBundle(this.m_bundleName);
        }
        catch (MissingResourceException e) {
            System.out.println(e);
        }
        this.m_refreshCounter = m_staticRefreshCounter;
    }

    public static ResourceManager getResourceManager() {
        return ResourceManager.getResourceManager(null);
    }

    public static synchronized ResourceManager getResourceManager(String resourceName) {
        ResourceManager resource;
        if (resourceName == null) {
            resourceName = "resource";
        }
        if ((resource = (ResourceManager)m_resources.get(resourceName)) == null) {
            resource = new ResourceManager(resourceName);
            m_resources.put(resourceName, resource);
        }
        return resource;
    }

    public static synchronized void refresh() {
        m_resources = new Hashtable();
        ++m_staticRefreshCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getString(String key) {
        String msg;
        ResourceManager resourceManager = this;
        synchronized (resourceManager) {
            if (this.m_refreshCounter != m_staticRefreshCounter) {
                this.refreshBundle();
            }
        }
        if (this.m_bundle == null) {
            msg = key;
        } else {
            try {
                msg = this.m_bundle.getString(key);
            }
            catch (MissingResourceException ex) {
                msg = key;
                System.out.println(key + " is missing from resource bundle \"" + this.m_bundleName + "\"");
            }
        }
        return msg;
    }

    public BufferedImage getBufferedImage(String filename) {
        BufferedImage image;
        block2: {
            image = null;
            InputStream is = this.getClass().getResourceAsStream(filename);
            if (is == null) break block2;
            try {
                JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)is);
                image = decoder.decodeAsBufferedImage();
            }
            catch (IOException e) {}
        }
        return image;
    }

    public String format(String key) {
        return this.getString(key);
    }

    public String format(String pattern, Object o0) {
        return MessageFormat.format(this.getString(pattern), o0);
    }

    public String format(String pattern, Object o0, Object o1) {
        return MessageFormat.format(this.getString(pattern), o0, o1);
    }

    public String format(String pattern, Object o0, Object o1, Object o2) {
        return MessageFormat.format(this.getString(pattern), o0, o1, o2);
    }

    public String format(String pattern, Object o0, Object o1, Object o2, Object o3) {
        return MessageFormat.format(this.getString(pattern), o0, o1, o2, o3);
    }
}

