/*
 * Decompiled with CFR 0.152.
 */
package wicket.authorization.strategies.role.annotations;

import wicket.Component;
import wicket.authorization.Action;
import wicket.authorization.strategies.role.AbstractRoleAuthorizationStrategy;
import wicket.authorization.strategies.role.IRoleCheckingStrategy;
import wicket.authorization.strategies.role.Roles;
import wicket.authorization.strategies.role.annotations.AuthorizeAction;
import wicket.authorization.strategies.role.annotations.AuthorizeActions;
import wicket.authorization.strategies.role.annotations.AuthorizeInstantiation;

public class AnnotationsRoleAuthorizationStrategy
extends AbstractRoleAuthorizationStrategy {
    public AnnotationsRoleAuthorizationStrategy(IRoleCheckingStrategy roleCheckingStrategy) {
        super(roleCheckingStrategy);
    }

    public boolean isInstantiationAuthorized(Class componentClass) {
        AuthorizeInstantiation classAnnotation;
        AuthorizeInstantiation packageAnnotation;
        boolean authorized = true;
        Package componentPackage = componentClass.getPackage();
        if (componentPackage != null && (packageAnnotation = componentPackage.getAnnotation(AuthorizeInstantiation.class)) != null) {
            authorized = this.hasAny(new Roles(packageAnnotation.value()));
        }
        if ((classAnnotation = componentClass.getAnnotation(AuthorizeInstantiation.class)) != null) {
            authorized = this.hasAny(new Roles(classAnnotation.value()));
        }
        return authorized;
    }

    public boolean isActionAuthorized(Component component, Action action) {
        Class<?> componentClass = component.getClass();
        if (!this.check(action, componentClass.getAnnotation(AuthorizeAction.class))) {
            return false;
        }
        AuthorizeActions authorizeActionsAnnotation = componentClass.getAnnotation(AuthorizeActions.class);
        if (authorizeActionsAnnotation != null) {
            for (AuthorizeAction authorizeActionAnnotation : authorizeActionsAnnotation.actions()) {
                if (this.check(action, authorizeActionAnnotation)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean check(Action action, AuthorizeAction authorizeActionAnnotation) {
        return authorizeActionAnnotation == null || !action.getName().equals(authorizeActionAnnotation.action()) || this.hasAny(new Roles(authorizeActionAnnotation.roles()));
    }
}

