/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.xdoclet.plugin.web.ClassAttributeComparator;
import org.xdoclet.plugin.web.ClassTagPredicate;

public class WebUtils {
    protected static final String SERVLET_22 = "2.2";
    protected static final String SERVLET_23 = "2.3";
    protected static final String SERVLET_24 = "2.4";
    private String servletVersion;
    private static final HashMap listenerInterfaces = new HashMap();

    public WebUtils(String servletVersion) throws ClassNotFoundException {
        try {
            this.getClass().getClassLoader().loadClass("javax.servlet.Servlet");
        }
        catch (ClassNotFoundException ex) {
            throw new ClassNotFoundException("The servlet api jar must be in the classpath (" + ex.getMessage() + ")");
        }
        this.servletVersion = servletVersion;
    }

    public Collection getListeners(Collection metaData) {
        ArrayList listeners = new ArrayList();
        String[] interfaces = (String[])listenerInterfaces.get(this.servletVersion);
        if (interfaces != null) {
            ClassTagPredicate predicate = new ClassTagPredicate(interfaces, "web.listener");
            CollectionUtils.select((Collection)metaData, (Predicate)predicate, listeners);
            Collections.sort(listeners, new ClassAttributeComparator("web.listener", "order"));
        }
        return listeners;
    }

    public boolean isMinimumServletVersion(String minimalVersion) {
        return this.servletVersion.compareTo(minimalVersion) >= 0;
    }

    static {
        listenerInterfaces.put(SERVLET_24, new String[]{"javax.servlet.ServletContextAttributeListener", "javax.servlet.ServletContextListener", "javax.servlet.ServletRequestAttributeListener", "javax.servlet.ServletRequestListener", "javax.servlet.http.HttpSessionActivationListener", "javax.servlet.http.HttpSessionAttributeListener", "javax.servlet.http.HttpSessionBindingListener", "javax.servlet.http.HttpSessionListener"});
        listenerInterfaces.put(SERVLET_23, new String[]{"javax.servlet.ServletContextAttributeListener", "javax.servlet.ServletContextListener", "javax.servlet.http.HttpSessionActivationListener", "javax.servlet.http.HttpSessionAttributeListener", "javax.servlet.http.HttpSessionBindingListener", "javax.servlet.http.HttpSessionListener"});
        listenerInterfaces.put(SERVLET_22, new String[0]);
    }
}

