/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.web.jelly;

import com.thoughtworks.qdox.model.DocletTag;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.xml.sax.SAXException;

public class ConditionalElementTag
extends TagSupport {
    private String xmlTag;
    private DocletTag docletTag;
    private Object obj;
    private String propertyName;

    public void doTag(XMLOutput xmlOutput) throws MissingAttributeException {
        if (this.xmlTag == null) {
            throw new MissingAttributeException("tag");
        }
        if (this.obj == null && this.docletTag == null) {
            throw new MissingAttributeException("obj or doclettag");
        }
        if (this.obj != null && this.docletTag != null) {
            throw new RuntimeException("You can't define both obj and doclettag in this tag.");
        }
        if (this.propertyName == null) {
            throw new MissingAttributeException("property");
        }
        try {
            String value = null;
            try {
                if (this.obj != null) {
                    this.propertyName = this.deHyphenate(this.propertyName, false);
                } else {
                    this.propertyName = this.deHyphenate(this.propertyName, true);
                    this.obj = this.docletTag;
                }
                value = BeanUtils.getSimpleProperty((Object)this.obj, (String)this.propertyName);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException(ex);
            }
            if (value != null) {
                xmlOutput.startElement(this.xmlTag);
                xmlOutput.write(value);
                xmlOutput.endElement(this.xmlTag);
            }
        }
        catch (SAXException ex) {
            throw new RuntimeException("Couldn't do output: " + ex.getMessage(), ex);
        }
    }

    public void setTag(String xmlTag) {
        this.xmlTag = xmlTag;
    }

    public void setObj(Object object) {
        this.obj = object;
    }

    public void setDoclettag(DocletTag tag) {
        this.docletTag = tag;
    }

    public void setProperty(String property) {
        this.propertyName = property;
    }

    private String deHyphenate(String hyphenatedName, boolean isDocletTag) {
        StringBuffer sb = new StringBuffer();
        char[] chars = hyphenatedName.toCharArray();
        boolean capitalizeNext = false;
        int i = 0;
        while (i < chars.length) {
            char currentChar = chars[i];
            if (currentChar == '-' || currentChar == '.') {
                capitalizeNext = true;
            } else if (capitalizeNext) {
                currentChar = Character.toUpperCase(currentChar);
                sb.append(currentChar);
                capitalizeNext = false;
            } else {
                sb.append(currentChar);
            }
            ++i;
        }
        if (isDocletTag && (hyphenatedName.equals("name") || hyphenatedName.equals("class") || hyphenatedName.equals("value"))) {
            sb.append('_');
        }
        return sb.toString();
    }
}

