/*
 * The Apache Software License, Version 1.1
 *
 *
 * Copyright (c) 1999,2000 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Xerces" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation and was
 * originally based on software copyright (c) 1999, International
 * Business Machines, Inc., http://www.apache.org.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.xerces.impl;

import java.io.IOException;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLString;
import org.xml.sax.Locator;

/**
 * @author Stubs generated by DesignDoc on Mon Oct 09 22:31:27 PDT 2000
 * @version $Id: DesignDoc.java,v 1.1.2.1 2000/09/15 21:57:12 andyc Exp $
 */
public class XMLEntityScanner
    implements Locator {

    //
    // Methods
    //

    /**
     * peekChar
     * 
     * @return 
     */
    public int peekChar()
        throws IOException {
        return -1;
    } // peekChar

    /**
     * scanChar
     * 
     * @return 
     */
    public int scanChar()
        throws IOException {
        return -1;
    } // scanChar

    /**
     * scanNmtoken
     * 
     * @return 
     */
    public String scanNmtoken()
        throws IOException {
        return null;
    } // scanNmtoken

    /**
     * scanName
     * 
     * @return 
     */
    public String scanName()
        throws IOException {
        return null;
    } // scanName

    /**
     * scanQName
     * 
     * @param qname 
     * 
     * @return True if QName was scanned.
     */
    public boolean scanQName(QName qname)
        throws IOException {
        return false;
    } // scanQName

    /**
     * Scans parsed content in an XML document.
     * 
     * @param content 
     * 
     * @return The next character on the stream.
     */
    public int scanContent(XMLString content)
        throws IOException {
        return -1;
    } // scanContent

    /**
     * Scans attribute content.
     * 
     * @param quote 
     * @param content 
     * 
     * @return The next character on the stream.
     */
    public int scanAttContent(int quote, XMLString content)
        throws IOException {
        return -1;
    } // scanAttContent

    /**
     * scanData
     * 
     * @param delimiter 
     * @param data 
     * 
     * @return True if there is more data to scan.
     */
    public boolean scanData(String delimiter, XMLString data)
        throws IOException {
        return false;
    } // scanData

    /**
     * skipChar
     * 
     * @param c 
     * 
     * @return True if the char was skipped.
     */
    public boolean skipChar(int c)
        throws IOException {
        return false;
    } // skipChar

    /**
     * skipSpaces
     * 
     * @return True if spaces were skipped.
     */
    public boolean skipSpaces()
        throws IOException {
        return false;
    } // skipSpaces

    /**
     * skipString
     * 
     * @param s The string to skip.
     * 
     * @return True if string was skipped.
     */
    public boolean skipString(String s)
        throws IOException {
        return false;
    } // skipString

    //
    // Locator methods
    //

    /**
     * getPublicId
     * 
     * @return 
     */
    public String getPublicId() {
        return null;
    } // getPublicId

    /**
     * getSystemId
     * 
     * @return 
     */
    public String getSystemId() {
        return null;
    } // getSystemId

    /**
     * getLineNumber
     * 
     * @return 
     */
    public int getLineNumber() {
        return -1;
    } // getLineNumber

    /**
     * getColumnNumber
     * 
     * @return 
     */
    public int getColumnNumber() {
        return -1;
    } // getColumnNumber

} // class XMLEntityScanner
