/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.dom;

import com.sun.org.apache.xerces.internal.dom.CoreDocumentImpl;
import com.sun.org.apache.xerces.internal.dom.DOMMessageFormatter;
import com.sun.org.apache.xerces.internal.dom.ElementImpl;
import com.sun.org.apache.xerces.internal.util.URI;
import com.sun.org.apache.xerces.internal.xni.NamespaceContext;
import com.sun.org.apache.xerces.internal.xs.XSTypeDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;

public class ElementNSImpl
extends ElementImpl {
    static final long serialVersionUID = -9142310625494392642L;
    static final String xmlURI = "http://www.w3.org/XML/1998/namespace";
    protected String namespaceURI;
    protected String localName;
    transient XSTypeDefinition type;

    protected ElementNSImpl() {
    }

    protected ElementNSImpl(CoreDocumentImpl ownerDocument, String namespaceURI, String qualifiedName) throws DOMException {
        super(ownerDocument, qualifiedName);
        this.setName(namespaceURI, qualifiedName);
    }

    private void setName(String namespaceURI, String qname) {
        this.namespaceURI = namespaceURI;
        if (namespaceURI != null) {
            String string = this.namespaceURI = namespaceURI.length() == 0 ? null : namespaceURI;
        }
        if (qname == null) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null);
            throw new DOMException(14, msg);
        }
        int colon1 = qname.indexOf(58);
        int colon2 = qname.lastIndexOf(58);
        this.ownerDocument().checkNamespaceWF(qname, colon1, colon2);
        if (colon1 < 0) {
            this.localName = qname;
            this.ownerDocument().checkQName(null, this.localName);
            if (qname.equals("xmlns") && (namespaceURI == null || !namespaceURI.equals(NamespaceContext.XMLNS_URI)) || namespaceURI != null && namespaceURI.equals(NamespaceContext.XMLNS_URI) && !qname.equals("xmlns")) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null);
                throw new DOMException(14, msg);
            }
        } else {
            String prefix = qname.substring(0, colon1);
            if (namespaceURI == null || prefix.equals("xml") && !namespaceURI.equals(NamespaceContext.XML_URI)) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null);
                throw new DOMException(14, msg);
            }
            this.localName = qname.substring(colon2 + 1);
            this.ownerDocument().checkQName(prefix, this.localName);
            this.ownerDocument().checkDOMNSErr(prefix, namespaceURI);
        }
    }

    protected ElementNSImpl(CoreDocumentImpl ownerDocument, String namespaceURI, String qualifiedName, String localName) throws DOMException {
        super(ownerDocument, qualifiedName);
        this.localName = localName;
        this.namespaceURI = namespaceURI;
    }

    protected ElementNSImpl(CoreDocumentImpl ownerDocument, String value) {
        super(ownerDocument, value);
    }

    void rename(String namespaceURI, String qualifiedName) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.name = qualifiedName;
        this.setName(namespaceURI, qualifiedName);
        this.reconcileDefaultAttributes();
    }

    protected void setValues(CoreDocumentImpl ownerDocument, String namespaceURI, String qualifiedName, String localName) {
        this.firstChild = null;
        this.previousSibling = null;
        this.nextSibling = null;
        this.fNodeListCache = null;
        this.attributes = null;
        this.flags = 0;
        this.setOwnerDocument(ownerDocument);
        this.needsSyncData(true);
        this.name = qualifiedName;
        this.localName = localName;
        this.namespaceURI = namespaceURI;
    }

    public String getNamespaceURI() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.namespaceURI;
    }

    public String getPrefix() {
        int index;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return (index = this.name.indexOf(58)) < 0 ? null : this.name.substring(0, index);
    }

    public void setPrefix(String prefix) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.ownerDocument().errorChecking) {
            if (this.isReadOnly()) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, msg);
            }
            if (prefix != null && prefix.length() != 0) {
                if (!CoreDocumentImpl.isXMLName(prefix, this.ownerDocument().isXML11Version())) {
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
                    throw new DOMException(5, msg);
                }
                if (this.namespaceURI == null || prefix.indexOf(58) >= 0) {
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null);
                    throw new DOMException(14, msg);
                }
                if (prefix.equals("xml") && !this.namespaceURI.equals(xmlURI)) {
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null);
                    throw new DOMException(14, msg);
                }
            }
        }
        this.name = prefix != null && prefix.length() != 0 ? prefix + ":" + this.localName : this.localName;
    }

    public String getLocalName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.localName;
    }

    public String getBaseURI() {
        String baseURI;
        String parentElementBaseURI;
        String uri;
        Attr attrNode;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes != null && (attrNode = (Attr)this.attributes.getNamedItemNS(xmlURI, "base")) != null && (uri = attrNode.getNodeValue()).length() != 0) {
            try {
                uri = new URI(uri).toString();
            }
            catch (URI.MalformedURIException e) {
                return null;
            }
            return uri;
        }
        String string = parentElementBaseURI = this.parentNode() != null ? this.parentNode().getBaseURI() : null;
        if (parentElementBaseURI != null) {
            try {
                return new URI(parentElementBaseURI).toString();
            }
            catch (URI.MalformedURIException e) {
                return null;
            }
        }
        String string2 = baseURI = this.ownerNode != null ? this.ownerNode.getBaseURI() : null;
        if (baseURI != null) {
            try {
                return new URI(baseURI).toString();
            }
            catch (URI.MalformedURIException e) {
                return null;
            }
        }
        return null;
    }

    public String getTypeName() {
        if (this.type != null) {
            return this.type.getName();
        }
        return null;
    }

    public String getTypeNamespace() {
        if (this.type != null) {
            return this.type.getNamespace();
        }
        return null;
    }

    public boolean isDerivedFrom(String typeNamespaceArg, String typeNameArg, int derivationMethod) {
        if (this.type != null) {
            return this.type.derivedFrom(typeNamespaceArg, typeNameArg, (short)derivationMethod);
        }
        return false;
    }

    public void setType(XSTypeDefinition type) {
        this.type = type;
    }
}

