/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp;

import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.apache.xerces.jaxp.SAXParserImpl;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class SAXParserFactoryImpl
extends SAXParserFactory {
    private static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    private static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    private static final String XINCLUDE_FEATURE = "http://apache.org/xml/features/xinclude";
    private Hashtable features;
    private Schema grammar;
    private boolean isXIncludeAware;
    private boolean fSecureProcess = false;

    @Override
    public SAXParser newSAXParser() throws ParserConfigurationException {
        SAXParserImpl saxParserImpl;
        try {
            saxParserImpl = new SAXParserImpl(this, this.features, this.fSecureProcess);
        }
        catch (SAXException se) {
            throw new ParserConfigurationException(se.getMessage());
        }
        return saxParserImpl;
    }

    private SAXParserImpl newSAXParserImpl() throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        SAXParserImpl saxParserImpl;
        try {
            saxParserImpl = new SAXParserImpl(this, this.features);
        }
        catch (SAXNotSupportedException e) {
            throw e;
        }
        catch (SAXNotRecognizedException e) {
            throw e;
        }
        catch (SAXException se) {
            throw new ParserConfigurationException(se.getMessage());
        }
        return saxParserImpl;
    }

    @Override
    public void setFeature(String name, boolean value) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            this.fSecureProcess = value;
            return;
        }
        if (name.equals(NAMESPACES_FEATURE)) {
            this.setNamespaceAware(value);
            return;
        }
        if (name.equals(VALIDATION_FEATURE)) {
            this.setValidating(value);
            return;
        }
        if (name.equals(XINCLUDE_FEATURE)) {
            this.setXIncludeAware(value);
            return;
        }
        if (this.features == null) {
            this.features = new Hashtable();
        }
        this.features.put(name, value ? Boolean.TRUE : Boolean.FALSE);
        try {
            this.newSAXParserImpl();
        }
        catch (SAXNotSupportedException e) {
            this.features.remove(name);
            throw e;
        }
        catch (SAXNotRecognizedException e) {
            this.features.remove(name);
            throw e;
        }
    }

    @Override
    public boolean getFeature(String name) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            return this.fSecureProcess;
        }
        if (name.equals(NAMESPACES_FEATURE)) {
            return this.isNamespaceAware();
        }
        if (name.equals(VALIDATION_FEATURE)) {
            return this.isValidating();
        }
        if (name.equals(XINCLUDE_FEATURE)) {
            return this.isXIncludeAware();
        }
        return this.newSAXParserImpl().getXMLReader().getFeature(name);
    }

    @Override
    public Schema getSchema() {
        return this.grammar;
    }

    @Override
    public void setSchema(Schema grammar) {
        this.grammar = grammar;
    }

    @Override
    public boolean isXIncludeAware() {
        return this.isXIncludeAware;
    }

    @Override
    public void setXIncludeAware(boolean state) {
        this.isXIncludeAware = state;
    }
}

