/*
 * Decompiled with CFR 0.152.
 */
import java.io.CharArrayReader;
import java.io.Reader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

class CloneParser {
    CloneParser() {
    }

    public static void main(String[] args) throws Exception {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        XmlPullParser mpp = factory.newPullParser();
        String XML = "<foo><baz>bar</baz><moo>maz</moo></foo>";
        System.out.println("parser implementation class is " + mpp.getClass());
        CloenableCharArrayReader cpp = new CloenableCharArrayReader("<foo><baz>bar</baz><moo>maz</moo></foo>".toCharArray());
        mpp.setInput((Reader)cpp);
        mpp.next();
        CloneParser.print(mpp);
        mpp.next();
        CloneParser.print(mpp);
        System.out.println(">>> SPLIT POINT " + mpp);
        XmlPullParser m2 = CloneParser.cloneParserIfCloneable(mpp);
        mpp.next();
        CloneParser.print(mpp);
        mpp.next();
        CloneParser.print(mpp);
        mpp.next();
        CloneParser.print(mpp);
        while (mpp.getEventType() != 1) {
            mpp.next();
            CloneParser.print(mpp);
        }
        System.out.println(">>> CLONED PARSER " + m2);
        while (m2.getEventType() != 1) {
            m2.next();
            CloneParser.print(m2);
        }
        System.out.println(">>> END");
    }

    private static XmlPullParser cloneParserIfCloneable(XmlPullParser pp) throws CloneNotSupportedException {
        if (pp instanceof Cloneable) {
            Object o;
            try {
                o = pp.getClass().getMethod("clone", null).invoke((Object)pp, null);
            }
            catch (Exception e) {
                CloneNotSupportedException ee = new CloneNotSupportedException("failed to call clone() on  " + pp + ":" + e);
                ee.initCause(e);
                throw ee;
            }
            return (XmlPullParser)o;
        }
        throw new CloneNotSupportedException("could not clone pull parser as it does not implement Cloneable " + pp.getClass());
    }

    private static void print(XmlPullParser pp) throws XmlPullParserException {
        int type = pp.getEventType();
        System.out.print(String.valueOf(XmlPullParser.TYPES[type]) + " ");
        if (type == 2 || type == 3) {
            System.out.print(pp.getName());
        } else if (type == 4) {
            System.out.print("'" + pp.getText() + "'");
        }
        System.out.println();
    }

    public static class CloenableCharArrayReader
    extends CharArrayReader
    implements Cloneable {
        public CloenableCharArrayReader(char[] buf) {
            super(buf);
        }

        public Object clone() throws CloneNotSupportedException {
            CloenableCharArrayReader cloned = (CloenableCharArrayReader)super.clone();
            cloned.buf = (char[])this.buf.clone();
            cloned.lock = cloned;
            return cloned;
        }
    }
}

