/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import ai.h2o.automl.AutoML;
import ai.h2o.automl.ModelingStep;
import ai.h2o.automl.ModelingSteps;
import ai.h2o.automl.ModelingStepsProvider;
import ai.h2o.automl.ModelingStepsRegistry;
import java.util.concurrent.atomic.AtomicInteger;
import water.DKV;
import water.Freezable;
import water.Futures;
import water.Key;
import water.Keyed;
import water.Lockable;
import water.nbhm.NonBlockingHashMap;
import water.util.IcedHashMap;
import water.util.IcedHashSet;

public class AutoMLSession
extends Lockable<AutoMLSession> {
    private final String _projectName;
    private final ModelingStepsRegistry _modelingStepsRegistry;
    private IcedHashSet<Key<Keyed>> _resumableKeys = new IcedHashSet();
    private IcedHashMap<Key, String[]> _keySources = new IcedHashMap();
    private NonBlockingHashMap<String, AtomicInteger> _modelCounters = new NonBlockingHashMap();
    private transient NonBlockingHashMap<String, ModelingSteps> _availableStepsByProviderName = new NonBlockingHashMap();
    private transient AutoML _aml;

    private static Key<AutoMLSession> makeKey(String projectName) {
        return Key.make((String)("AutoMLSession_" + projectName));
    }

    public static AutoMLSession getInstance(String projectName) {
        AutoMLSession session = (AutoMLSession)DKV.getGet(AutoMLSession.makeKey(projectName));
        if (session == null) {
            session = new AutoMLSession(projectName);
            DKV.put((Keyed)session);
        }
        return session;
    }

    AutoMLSession(String projectName) {
        super(AutoMLSession.makeKey(projectName));
        this._projectName = projectName;
        this._modelingStepsRegistry = new ModelingStepsRegistry();
    }

    public ModelingStepsRegistry getModelingStepsRegistry() {
        return this._modelingStepsRegistry;
    }

    void attach(AutoML aml, boolean resume) {
        assert (this._projectName.equals(aml._key.toString())) : "AutoMLSession can only be attached to an AutoML instance from project '" + this._projectName + "', but got: " + aml._key;
        if (this._aml == null) {
            this._aml = aml;
            if (!resume) {
                this._availableStepsByProviderName.clear();
            }
        }
    }

    void detach() {
        for (ModelingSteps steps : this._availableStepsByProviderName.values()) {
            steps.cleanup();
        }
        this._aml = null;
        DKV.put((Keyed)this);
    }

    public ModelingStep getModelingStep(Key key) {
        if (!this._keySources.containsKey((Object)key)) {
            return null;
        }
        String[] identifiers = (String[])this._keySources.get((Object)key);
        assert (identifiers.length > 1);
        return this.getModelingStep(identifiers[0], identifiers[1]);
    }

    public ModelingStep getModelingStep(String providerName, String id) {
        ModelingSteps steps = this.getModelingSteps(providerName);
        return steps == null ? null : (ModelingStep)steps.getStep(id).orElse(null);
    }

    ModelingSteps getModelingSteps(String providerName) {
        if (!this._availableStepsByProviderName.containsKey((Object)providerName)) {
            ModelingStepsProvider provider = (ModelingStepsProvider)ModelingStepsRegistry.stepsByName.get((Object)providerName);
            if (provider == null) {
                throw new IllegalArgumentException("Missing provider for modeling steps '" + providerName + "'");
            }
            Object steps = provider.newInstance(this._aml);
            if (steps != null) {
                this._availableStepsByProviderName.put((Object)providerName, steps);
            }
        }
        return (ModelingSteps)((Object)this._availableStepsByProviderName.get((Object)providerName));
    }

    public void registerKeySource(Key key, ModelingStep step) {
        if (key != null && !this._keySources.containsKey((Object)key)) {
            this.atomicUpdate(() -> {
                String[] cfr_ignored_0 = (String[])this._keySources.put((Object)key, (Object)new String[]{step.getProvider(), step.getId()});
            });
        }
    }

    public void addResumableKey(Key key) {
        this.atomicUpdate(() -> this._resumableKeys.add((Freezable)key));
    }

    public Key[] getResumableKeys(String providerName, String id) {
        ModelingStep step = this.getModelingStep(providerName, id);
        if (step == null) {
            return new Key[0];
        }
        return (Key[])this._resumableKeys.stream().filter(k -> step.equals((Object)this.getModelingStep((Key)k))).toArray(Key[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nextModelCounter(String algoName, String type) {
        String key = algoName + "_" + type;
        if (!this._modelCounters.containsKey((Object)key)) {
            NonBlockingHashMap<String, AtomicInteger> nonBlockingHashMap = this._modelCounters;
            synchronized (nonBlockingHashMap) {
                if (!this._modelCounters.containsKey((Object)key)) {
                    this.atomicUpdate(() -> {
                        AtomicInteger cfr_ignored_0 = (AtomicInteger)this._modelCounters.put((Object)key, (Object)new AtomicInteger(0));
                    });
                }
            }
        }
        AtomicInteger c = new AtomicInteger();
        this.atomicUpdate(() -> c.set(((AtomicInteger)this._modelCounters.get((Object)key)).incrementAndGet()));
        return c.get();
    }

    protected Futures remove_impl(Futures fs, boolean cascade) {
        this._resumableKeys.clear();
        this._keySources.clear();
        this._availableStepsByProviderName.clear();
        return super.remove_impl(fs, cascade);
    }

    private void atomicUpdate(Runnable update) {
        update.run();
    }
}

