/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import java.util.Collections;
import java.util.Map;
import water.util.IcedHashMap;

final class StepResultState {
    private final String _id;
    private final IcedHashMap<String, StepResultState> _subStates = new IcedHashMap();
    private ResultStatus _status;
    private Throwable _error;

    StepResultState(String id) {
        this(id, (ResultStatus)null);
    }

    StepResultState(String id, ResultStatus status) {
        this(id, status, null);
    }

    StepResultState(String id, Throwable error) {
        this(id, ResultStatus.failed, error);
    }

    private StepResultState(String id, ResultStatus status, Throwable error) {
        this._id = id;
        this._status = status;
        this._error = error;
    }

    void setStatus(ResultStatus status) {
        assert (this._status == null);
        this._status = status;
    }

    void setStatus(Throwable error) {
        this.setStatus(ResultStatus.failed);
        this._error = error;
    }

    void addState(StepResultState state) {
        this._subStates.put((Object)state.id(), (Object)state);
    }

    boolean is(ResultStatus status) {
        return this._status == status;
    }

    String id() {
        return this._id;
    }

    ResultStatus status() {
        return this._status;
    }

    Throwable error() {
        return this._error;
    }

    StepResultState subState(String id) {
        return (StepResultState)this._subStates.get((Object)id);
    }

    Map<String, StepResultState> subStates() {
        return Collections.unmodifiableMap(this._subStates);
    }

    void resolveState(Resolution strategy) {
        if (this._status != null) {
            return;
        }
        if (this._subStates.size() == 0) {
            this.setStatus(ResultStatus.skipped);
        } else if (this._subStates.size() == 1 && this._subStates.containsKey((Object)this.id())) {
            StepResultState state = this.subState(this.id());
            this._status = state.status();
            this._error = state.error();
            this._subStates.clear();
            this._subStates.putAll(state.subStates());
        } else {
            switch (strategy) {
                case sameAsMain: {
                    StepResultState state = this.subState(this.id());
                    if (state != null) {
                        this._status = state.status();
                        this._error = state.error();
                        break;
                    }
                    this._status = ResultStatus.cancelled;
                    break;
                }
                case optimistic: {
                    if (this._subStates.values().stream().anyMatch(s -> s.is(ResultStatus.success))) {
                        this._status = ResultStatus.success;
                        break;
                    }
                    if (this._subStates.values().stream().anyMatch(s -> s.is(ResultStatus.cancelled))) {
                        this._status = ResultStatus.cancelled;
                        break;
                    }
                    if (this._subStates.values().stream().anyMatch(s -> s.is(ResultStatus.failed))) {
                        this._subStates.values().stream().filter(s -> s.is(ResultStatus.failed)).limit(1L).findFirst().ifPresent(s -> this.setStatus(s.error()));
                        break;
                    }
                    this._status = ResultStatus.skipped;
                    break;
                }
                case pessimistic: {
                    if (this._subStates.values().stream().anyMatch(s -> s.is(ResultStatus.failed))) {
                        this._subStates.values().stream().filter(s -> s.is(ResultStatus.failed)).limit(1L).findFirst().ifPresent(s -> this.setStatus(s.error()));
                        break;
                    }
                    this._status = this._subStates.values().stream().anyMatch(s -> s.is(ResultStatus.cancelled)) ? ResultStatus.cancelled : (this._subStates.values().stream().anyMatch(s -> s.is(ResultStatus.success)) ? ResultStatus.success : ResultStatus.skipped);
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StepResultState{");
        sb.append("_id='").append(this._id).append('\'');
        sb.append(", _status=").append((Object)this._status);
        if (this._error != null) {
            sb.append(", _error=").append(this._error);
        }
        if (this._subStates.size() > 0) {
            sb.append(", _subStates=").append(this._subStates);
        }
        sb.append('}');
        return sb.toString();
    }

    static enum Resolution {
        sameAsMain,
        optimistic,
        pessimistic;

    }

    static enum ResultStatus {
        skipped,
        cancelled,
        failed,
        success;

    }
}

