/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import water.Iced;

public class StepDefinition
extends Iced<StepDefinition> {
    String _name;
    Alias _alias;
    Step[] _steps;

    public StepDefinition() {
    }

    public StepDefinition(String name) {
        this(name, Alias.all);
    }

    public StepDefinition(String name, Alias alias) {
        this._name = name;
        this._alias = alias;
    }

    public StepDefinition(String name, String ... ids) {
        this._name = name;
        this._steps = new Step[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            this._steps[i] = new Step(ids[i]);
        }
    }

    public StepDefinition(String name, Step ... steps) {
        this._name = name;
        this._steps = steps;
    }

    public String getName() {
        return this._name;
    }

    public Alias getAlias() {
        return this._alias;
    }

    public List<Step> getSteps() {
        return this._steps == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(this._steps));
    }

    public String toString() {
        return "{" + this._name + " : " + (this._steps == null ? this._alias : Arrays.toString((Object[])this._steps)) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        StepDefinition that = (StepDefinition)((Object)o);
        return this._name.equals(that._name) && this._alias == that._alias && Arrays.equals((Object[])this._steps, (Object[])that._steps);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this._name, this._alias});
        result = 31 * result + Arrays.hashCode((Object[])this._steps);
        return result;
    }

    public static class Step
    extends Iced<Step> {
        public static final int DEFAULT_GROUP = -1;
        public static final int DEFAULT_WEIGHT = -1;
        String _id;
        int _group = -1;
        int _weight = -1;

        public Step() {
        }

        public Step(String _id) {
            this._id = _id;
        }

        public Step(String id, int group, int weight) {
            assert (group == -1 || group >= 0) : "non-default group must be >= 0";
            assert (weight == -1 || weight >= 0) : "non-default weight must be >= 0";
            this._id = id;
            this._group = group;
            this._weight = weight;
        }

        public String getId() {
            return this._id;
        }

        public int getGroup() {
            return this._group;
        }

        public int getWeight() {
            return this._weight;
        }

        public String toString() {
            String s = this._id;
            if (this._group > -1 || this._weight > -1) {
                s = s + " (";
                String sep = "";
                if (this._group > -1) {
                    s = s + sep + this._group + "g";
                    sep = ", ";
                }
                if (this._weight > -1) {
                    s = s + sep + this._weight + "w";
                    sep = ", ";
                }
                s = s + ")";
            }
            return s;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Step step = (Step)((Object)o);
            return this._id.equals(step._id) && this._group == step._group && this._weight == step._weight;
        }

        public int hashCode() {
            return Objects.hash(this._id, this._group, this._weight);
        }
    }

    public static enum Alias {
        all,
        defaults,
        grids,
        exploitation,
        optionals;

    }
}

