/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl.modeling;

import ai.h2o.automl.Algo;
import ai.h2o.automl.AutoML;
import ai.h2o.automl.ModelParametersProvider;
import ai.h2o.automl.ModelingStep;
import ai.h2o.automl.ModelingSteps;
import ai.h2o.automl.ModelingStepsProvider;
import ai.h2o.automl.preprocessing.PreprocessingConfig;
import ai.h2o.automl.preprocessing.TargetEncoding;
import hex.deeplearning.DeepLearningModel;
import java.util.HashMap;
import java.util.Map;

public class DeepLearningStepsProvider
implements ModelingStepsProvider<DeepLearningSteps>,
ModelParametersProvider<DeepLearningModel.DeepLearningParameters> {
    @Override
    public String getName() {
        return DeepLearningSteps.NAME;
    }

    @Override
    public DeepLearningSteps newInstance(AutoML aml) {
        return new DeepLearningSteps(aml);
    }

    @Override
    public DeepLearningModel.DeepLearningParameters newDefaultParameters() {
        return new DeepLearningModel.DeepLearningParameters();
    }

    public static class DeepLearningSteps
    extends ModelingSteps {
        static final String NAME = Algo.DeepLearning.name();
        private final ModelingStep[] defaults = new DeepLearningModelStep[]{new DeepLearningModelStep("def_1", this.aml()){

            public DeepLearningModel.DeepLearningParameters prepareModelParameters() {
                DeepLearningModel.DeepLearningParameters params = new DeepLearningModel.DeepLearningParameters();
                params._hidden = new int[]{10, 10, 10};
                return params;
            }
        }};
        private final ModelingStep[] grids = new DeepLearningGridStep[]{new DeepLearningGridStep("grid_1", this.aml()){

            @Override
            public Map<String, Object[]> prepareSearchParameters() {
                Map<String, Object[]> searchParams = super.prepareSearchParameters();
                searchParams.put("_hidden", (Object[])new Integer[][]{{20}, {50}, {100}});
                searchParams.put("_hidden_dropout_ratios", (Object[])new Double[][]{{0.0}, {0.1}, {0.2}, {0.3}, {0.4}, {0.5}});
                return searchParams;
            }
        }, new DeepLearningGridStep("grid_2", this.aml()){

            @Override
            public Map<String, Object[]> prepareSearchParameters() {
                Map<String, Object[]> searchParams = super.prepareSearchParameters();
                searchParams.put("_hidden", (Object[])new Integer[][]{{20, 20}, {50, 50}, {100, 100}});
                searchParams.put("_hidden_dropout_ratios", (Object[])new Double[][]{{0.0, 0.0}, {0.1, 0.1}, {0.2, 0.2}, {0.3, 0.3}, {0.4, 0.4}, {0.5, 0.5}});
                return searchParams;
            }
        }, new DeepLearningGridStep("grid_3", this.aml()){

            @Override
            public Map<String, Object[]> prepareSearchParameters() {
                Map<String, Object[]> searchParams = super.prepareSearchParameters();
                searchParams.put("_hidden", (Object[])new Integer[][]{{20, 20, 20}, {50, 50, 50}, {100, 100, 100}});
                searchParams.put("_hidden_dropout_ratios", (Object[])new Double[][]{{0.0, 0.0, 0.0}, {0.1, 0.1, 0.1}, {0.2, 0.2, 0.2}, {0.3, 0.3, 0.3}, {0.4, 0.4, 0.4}, {0.5, 0.5, 0.5}});
                return searchParams;
            }
        }};

        public DeepLearningSteps(AutoML autoML) {
            super(autoML);
        }

        @Override
        public String getProvider() {
            return NAME;
        }

        @Override
        protected ModelingStep[] getDefaultModels() {
            return this.defaults;
        }

        @Override
        protected ModelingStep[] getGrids() {
            return this.grids;
        }

        static abstract class DeepLearningGridStep
        extends ModelingStep.GridStep<DeepLearningModel> {
            DeepLearningGridStep(String id, AutoML autoML) {
                super(NAME, Algo.DeepLearning, id, autoML);
            }

            public DeepLearningModel.DeepLearningParameters prepareModelParameters() {
                DeepLearningModel.DeepLearningParameters params = new DeepLearningModel.DeepLearningParameters();
                params._epochs = 10000.0;
                params._adaptive_rate = true;
                params._activation = DeepLearningModel.DeepLearningParameters.Activation.RectifierWithDropout;
                return params;
            }

            @Override
            protected PreprocessingConfig getPreprocessingConfig() {
                PreprocessingConfig config = super.getPreprocessingConfig();
                config.put(TargetEncoding.CONFIG_PREPARE_CV_ONLY, this.aml().isCVEnabled());
                return config;
            }

            @Override
            public Map<String, Object[]> prepareSearchParameters() {
                HashMap<String, Object[]> searchParams = new HashMap<String, Object[]>();
                searchParams.put("_rho", new Double[]{0.9, 0.95, 0.99});
                searchParams.put("_epsilon", new Double[]{1.0E-6, 1.0E-7, 1.0E-8, 1.0E-9});
                searchParams.put("_input_dropout_ratio", new Double[]{0.0, 0.05, 0.1, 0.15, 0.2});
                return searchParams;
            }
        }

        static abstract class DeepLearningModelStep
        extends ModelingStep.ModelStep<DeepLearningModel> {
            public DeepLearningModelStep(String id, AutoML autoML) {
                super(NAME, Algo.DeepLearning, id, autoML);
            }

            @Override
            protected PreprocessingConfig getPreprocessingConfig() {
                PreprocessingConfig config = super.getPreprocessingConfig();
                config.put(TargetEncoding.CONFIG_PREPARE_CV_ONLY, this.aml().isCVEnabled());
                return config;
            }
        }
    }
}

