/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl.modeling;

import ai.h2o.automl.Algo;
import ai.h2o.automl.AutoML;
import ai.h2o.automl.ModelParametersProvider;
import ai.h2o.automl.ModelingStep;
import ai.h2o.automl.ModelingSteps;
import ai.h2o.automl.ModelingStepsProvider;
import ai.h2o.automl.preprocessing.PreprocessingConfig;
import ai.h2o.automl.preprocessing.TargetEncoding;
import hex.Model;
import hex.glm.GLMModel;

public class GLMStepsProvider
implements ModelingStepsProvider<GLMSteps>,
ModelParametersProvider<GLMModel.GLMParameters> {
    @Override
    public String getName() {
        return GLMSteps.NAME;
    }

    @Override
    public GLMSteps newInstance(AutoML aml) {
        return new GLMSteps(aml);
    }

    @Override
    public GLMModel.GLMParameters newDefaultParameters() {
        return new GLMModel.GLMParameters();
    }

    public static class GLMSteps
    extends ModelingSteps {
        static final String NAME = Algo.GLM.name();
        private final ModelingStep[] defaults = new GLMModelStep[]{new GLMModelStep("def_1", this.aml()){

            @Override
            public GLMModel.GLMParameters prepareModelParameters() {
                GLMModel.GLMParameters params = super.prepareModelParameters();
                params._alpha = new double[]{0.0, 0.2, 0.4, 0.6, 0.8, 1.0};
                params._missing_values_handling = GLMModel.GLMParameters.MissingValuesHandling.MeanImputation;
                return params;
            }
        }};

        public GLMSteps(AutoML autoML) {
            super(autoML);
        }

        @Override
        public String getProvider() {
            return NAME;
        }

        @Override
        protected ModelingStep[] getDefaultModels() {
            return this.defaults;
        }

        static abstract class GLMModelStep
        extends ModelingStep.ModelStep<GLMModel> {
            GLMModelStep(String id, AutoML autoML) {
                super(NAME, Algo.GLM, id, autoML);
            }

            @Override
            protected void setStoppingCriteria(Model.Parameters parms, Model.Parameters defaults) {
            }

            public GLMModel.GLMParameters prepareModelParameters() {
                GLMModel.GLMParameters params = new GLMModel.GLMParameters();
                params._lambda_search = true;
                return params;
            }

            @Override
            protected PreprocessingConfig getPreprocessingConfig() {
                PreprocessingConfig config = super.getPreprocessingConfig();
                config.put(TargetEncoding.CONFIG_PREPARE_CV_ONLY, this.aml().isCVEnabled());
                return config;
            }
        }
    }
}

