/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.tools;

import com.mxgraph.layout.mxCompactTreeLayout;
import com.mxgraph.layout.mxEdgeLabelLayout;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.view.mxGraph;
import hex.genmodel.algos.tree.ConvertTreeOptions;
import hex.genmodel.algos.tree.SharedTreeGraph;
import hex.genmodel.algos.tree.SharedTreeSubgraph;
import hex.genmodel.algos.tree.TreeBackedMojoModel;
import hex.genmodel.tools.MojoPrinter;
import hex.genmodel.tools.PrintMojo;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jgrapht.Graph;
import org.jgrapht.ext.JGraphXAdapter;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedMultigraph;
import org.jgrapht.io.Attribute;
import org.jgrapht.io.DOTImporter;
import org.jgrapht.io.EdgeProvider;
import org.jgrapht.io.ImportException;
import org.jgrapht.io.VertexProvider;

public class JgraphtPrintMojo
extends PrintMojo
implements MojoPrinter {
    public void run() throws Exception {
        if (!MojoPrinter.Format.png.equals((Object)this.format)) {
            super.run();
        } else {
            this.validateArgs();
            if (this.genModel instanceof TreeBackedMojoModel) {
                TreeBackedMojoModel treeBackedModel = (TreeBackedMojoModel)this.genModel;
                ConvertTreeOptions options = new ConvertTreeOptions().withTreeConsistencyCheckEnabled();
                SharedTreeGraph g = treeBackedModel.convert(this.treeToPrint, null, options);
                this.printPng(g);
            } else {
                System.out.println("ERROR: Unknown MOJO type");
                System.exit(1);
            }
        }
    }

    public boolean supportsFormat(MojoPrinter.Format format) {
        return true;
    }

    private void printPng(SharedTreeGraph trees) throws IOException, ImportException {
        Path outputDirectoryPath = Paths.get(this.outputFileName, new String[0]);
        int numberOfTrees = trees.subgraphArray.size();
        if (numberOfTrees > 1) {
            if (this.outputFileName == null) {
                this.outputFileName = Paths.get("", new String[0]).toString();
            }
            if (Files.exists(outputDirectoryPath, new LinkOption[0]) && !Files.isDirectory(outputDirectoryPath, new LinkOption[0])) {
                Files.delete(outputDirectoryPath);
            }
            if (!Files.exists(outputDirectoryPath, new LinkOption[0])) {
                Files.createDirectory(outputDirectoryPath, new FileAttribute[0]);
            }
        }
        for (SharedTreeSubgraph tree : trees.subgraphArray) {
            Path dotSourceFilePath = Files.createTempFile("", "tmpOutputFileName.gv", new FileAttribute[0]);
            try (FileOutputStream fosTemp = new FileOutputStream(dotSourceFilePath.toFile());
                 PrintStream osTemp = new PrintStream(fosTemp);){
                tree.printDot(osTemp, this.maxLevelsToPrintPerEdge, this.detail, this.optionalTitle, this.pTreeOptions, true);
                this.generateOutputPng(dotSourceFilePath, this.getPngName(numberOfTrees, tree.name));
            }
            Files.delete(dotSourceFilePath);
        }
    }

    private void generateOutputPng(Path dotSourceFilePath, String treeName) throws ImportException, IOException {
        LabeledVertexProvider vertexProvider = new LabeledVertexProvider();
        LabeledEdgesProvider edgesProvider = new LabeledEdgesProvider();
        ComponentUpdater componentUpdater = new ComponentUpdater();
        DOTImporter importer = new DOTImporter((VertexProvider)vertexProvider, (EdgeProvider)edgesProvider, (org.jgrapht.io.ComponentUpdater)componentUpdater);
        DirectedMultigraph result = new DirectedMultigraph(LabeledEdge.class);
        try (FileInputStream is = new FileInputStream(dotSourceFilePath.toFile());
             InputStreamReader reader = new InputStreamReader(is);){
            importer.importGraph((Graph)result, (Reader)reader);
            JGraphXAdapter graphAdapter = new JGraphXAdapter((Graph)result);
            mxCompactTreeLayout treeLayout = new mxCompactTreeLayout((mxGraph)graphAdapter, true);
            mxEdgeLabelLayout nonOverlappingEdgesLayout = new mxEdgeLabelLayout((mxGraph)graphAdapter);
            treeLayout.execute(graphAdapter.getDefaultParent());
            nonOverlappingEdgesLayout.execute(graphAdapter.getDefaultParent());
            BufferedImage image = mxCellRenderer.createBufferedImage((mxGraph)graphAdapter, null, (double)2.0, (Color)Color.WHITE, (boolean)true, null);
            if (this.outputFileName != null) {
                ImageIO.write((RenderedImage)image, "PNG", new File(treeName));
            } else {
                ImageIO.write((RenderedImage)image, "PNG", System.out);
            }
        }
    }

    protected String getPngName(int numberOfTrees, String treeName) {
        if (numberOfTrees == 1) {
            return this.outputFileName;
        }
        return this.outputFileName + "/" + treeName.replaceAll("\\s+", "").replaceAll(",", "_") + ".png";
    }

    static class LabeledVertex {
        private String id;
        private String label;

        public LabeledVertex(String id) {
            this(id, null);
        }

        public LabeledVertex(String id, String label) {
            this.id = id;
            this.label = label;
        }

        public int hashCode() {
            return this.id == null ? 0 : this.id.hashCode();
        }

        public String toString() {
            return this.label;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LabeledVertex other = (LabeledVertex)obj;
            if (this.id == null) {
                return other.id == null;
            }
            return this.id.equals(other.id);
        }
    }

    private class LabeledEdge
    extends DefaultEdge {
        private String label;

        public LabeledEdge(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public String toString() {
            return this.label;
        }
    }

    private class ComponentUpdater
    implements org.jgrapht.io.ComponentUpdater<LabeledVertex> {
        private ComponentUpdater() {
        }

        public void update(LabeledVertex v, Map<String, Attribute> attrs) {
        }
    }

    private class LabeledEdgesProvider
    implements EdgeProvider<LabeledVertex, LabeledEdge> {
        private LabeledEdgesProvider() {
        }

        public LabeledEdge buildEdge(LabeledVertex f, LabeledVertex t, String l, Map<String, Attribute> attrs) {
            return new LabeledEdge(l);
        }
    }

    private class LabeledVertexProvider
    implements VertexProvider<LabeledVertex> {
        private LabeledVertexProvider() {
        }

        public LabeledVertex buildVertex(String id, Map<String, Attribute> attributes) {
            return new LabeledVertex(id, attributes.get("label").toString());
        }
    }
}

