/*
 * Decompiled with CFR 0.152.
 */
package water.network;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import water.network.SecurityUtils;

public class SecurityUtilsTest {
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldGenerateKeystoreAndConfig() throws Exception {
        try {
            String location = this.tmp.newFolder("ssl").getAbsolutePath();
            SecurityUtils.SSLCredentials testKeystore = SecurityUtils.generateSSLPair((String)"test123", (String)"h2o-keystore-test.jks", (String)location);
            String configPath = SecurityUtils.generateSSLConfig((SecurityUtils.SSLCredentials)testKeystore, (String)"test-ssl.properties");
            Assert.assertTrue((boolean)new File(testKeystore.jks.getLocation()).exists());
            Properties sslConfig = new Properties();
            sslConfig.load(new FileInputStream(configPath));
            Assert.assertEquals((Object)SecurityUtils.defaultTLSVersion(), (Object)sslConfig.getProperty("h2o_ssl_protocol"));
            Assert.assertEquals((Object)"h2o-keystore-test.jks", (Object)sslConfig.getProperty("h2o_ssl_jks_internal"));
            Assert.assertEquals((Object)"test123", (Object)sslConfig.getProperty("h2o_ssl_jks_password"));
            Assert.assertEquals((Object)"h2o-keystore-test.jks", (Object)sslConfig.getProperty("h2o_ssl_jts"));
            Assert.assertEquals((Object)"test123", (Object)sslConfig.getProperty("h2o_ssl_jts_password"));
        }
        finally {
            File props;
            File keystore = new File("h2o-keystore-test.jks");
            if (keystore.exists()) {
                keystore.deleteOnExit();
            }
            if ((props = new File("test-ssl.properties")).exists()) {
                props.deleteOnExit();
            }
        }
    }
}

