/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.uuid.ktor;

import io.ktor.util.ConversionService;
import io.ktor.util.DataConversionException;
import java.lang.reflect.Type;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.uuid.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\u000e"}, d2={"Lkotlinx/uuid/ktor/UUIDConversionService;", "Lio/ktor/util/ConversionService;", "()V", "fromValue", "Lkotlinx/uuid/UUID;", "value", "", "fromValues", "", "values", "", "type", "Ljava/lang/reflect/Type;", "toValues", "kotlinx-uuid-ktor-server"})
public final class UUIDConversionService
implements ConversionService {
    @NotNull
    public static final UUIDConversionService INSTANCE = new UUIDConversionService();

    private UUIDConversionService() {
    }

    @Nullable
    public Object fromValues(@NotNull List<String> values, @NotNull Type type) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (Intrinsics.areEqual((Object)type, UUID.class)) {
            UUID uUID;
            int n = values.size();
            switch (n) {
                case 0: {
                    uUID = null;
                    break;
                }
                case 1: {
                    uUID = this.fromValue(values.get(0));
                    break;
                }
                default: {
                    throw new DataConversionException("Multiple UUID values can't be converted to a single UUID");
                }
            }
            return uUID;
        }
        throw new DataConversionException("Type " + type + " is not supported by this ConversionService");
    }

    private final UUID fromValue(String value) {
        UUID uUID;
        try {
            uUID = new UUID(value);
        }
        catch (Throwable cause) {
            String string = cause.getMessage();
            throw new DataConversionException(string == null ? Intrinsics.stringPlus((String)"Failed to convert UUID: ", (Object)cause) : string);
        }
        return uUID;
    }

    @NotNull
    public List<String> toValues(@Nullable Object value) {
        List list;
        Object object = value;
        if (object instanceof UUID) {
            list = CollectionsKt.listOf((Object)((UUID)value).toString());
        } else if (object == null) {
            list = CollectionsKt.emptyList();
        } else {
            throw new DataConversionException("Value " + value + " is not supported by UUIDConversionService");
        }
        return list;
    }
}

