/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.latch;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.LatchException;
import com.sleepycat.je.latch.LatchNotHeldException;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.latch.SharedLatch;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class Java5SharedLatchImpl
extends ReentrantReadWriteLock
implements SharedLatch {
    private String name;
    private boolean noteLatch;
    static final /* synthetic */ boolean $assertionsDisabled;

    Java5SharedLatchImpl() {
        super(EnvironmentImpl.getFairLatches());
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNoteLatch(boolean noteLatch) {
        this.noteLatch = noteLatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireExclusive() throws DatabaseException {
        block6: {
            try {
                if (this.isWriteLockedByCurrentThread()) {
                    throw new LatchException(this.name + " already held");
                }
                this.writeLock().lock();
                if ($assertionsDisabled || !this.noteLatch) break block6;
                if (this.noteLatch()) {
                    break block6;
                }
                throw new AssertionError();
            }
            finally {
                if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                    throw new AssertionError();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquireExclusiveNoWait() throws DatabaseException {
        try {
            if (this.isWriteLockedByCurrentThread()) {
                throw new LatchException(this.name + " already held");
            }
            boolean ret = this.writeLock().tryLock();
            if (!$assertionsDisabled && this.noteLatch && !this.noteLatch()) {
                throw new AssertionError();
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireShared() throws DatabaseException {
        block5: {
            try {
                this.readLock().lock();
                if ($assertionsDisabled || !this.noteLatch) break block5;
                if (this.noteLatch()) {
                    break block5;
                }
                throw new AssertionError();
            }
            finally {
                if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                    throw new AssertionError();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws LatchNotHeldException {
        try {
            if (this.isWriteLockedByCurrentThread()) {
                this.writeLock().unlock();
                return;
            }
            this.readLock().unlock();
        }
        catch (IllegalMonitorStateException IMSE) {
            return;
        }
        finally {
            if (!$assertionsDisabled && this.noteLatch && !this.unNoteLatch()) {
                throw new AssertionError();
            }
        }
    }

    private boolean noteLatch() throws LatchException {
        return LatchSupport.latchTable.noteLatch(this);
    }

    private boolean unNoteLatch() {
        return LatchSupport.latchTable.unNoteLatch(this, this.name);
    }

    static {
        $assertionsDisabled = !Java5SharedLatchImpl.class.desiredAssertionStatus();
    }
}

