/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.Calendar;

public class CheckpointEnd
implements LoggableObject,
LogReadable {
    private String invoker;
    private Timestamp endTime;
    private long checkpointStartLsn;
    private boolean rootLsnExists;
    private long rootLsn;
    private long firstActiveLsn;
    private long lastNodeId;
    private int lastDbId;
    private long lastTxnId;
    private long id;

    public CheckpointEnd(String invoker, long checkpointStartLsn, long rootLsn, long firstActiveLsn, long lastNodeId, int lastDbId, long lastTxnId, long id) {
        this.invoker = invoker == null ? "" : invoker;
        Calendar cal = Calendar.getInstance();
        this.endTime = new Timestamp(cal.getTime().getTime());
        this.checkpointStartLsn = checkpointStartLsn;
        this.rootLsn = rootLsn;
        this.rootLsnExists = rootLsn != -1L;
        this.firstActiveLsn = firstActiveLsn == -1L ? checkpointStartLsn : firstActiveLsn;
        this.lastNodeId = lastNodeId;
        this.lastDbId = lastDbId;
        this.lastTxnId = lastTxnId;
        this.id = id;
    }

    public CheckpointEnd() {
        this.checkpointStartLsn = -1L;
        this.rootLsn = -1L;
        this.firstActiveLsn = -1L;
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_CKPT_END;
    }

    public boolean marshallOutsideWriteLatch() {
        return true;
    }

    public boolean countAsObsoleteWhenLogged() {
        return false;
    }

    public void postLogWork(long justLoggedLsn) {
    }

    public int getLogSize() {
        int size = LogUtils.getStringLogSize(this.invoker) + LogUtils.getTimestampLogSize() + LogUtils.getLongLogSize() + LogUtils.getBooleanLogSize() + LogUtils.getLongLogSize() + LogUtils.getLongLogSize() + LogUtils.getIntLogSize() + LogUtils.getLongLogSize() + LogUtils.getLongLogSize();
        if (this.rootLsnExists) {
            size += LogUtils.getLongLogSize();
        }
        return size;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeString(logBuffer, this.invoker);
        LogUtils.writeTimestamp(logBuffer, this.endTime);
        LogUtils.writeLong(logBuffer, this.checkpointStartLsn);
        LogUtils.writeBoolean(logBuffer, this.rootLsnExists);
        if (this.rootLsnExists) {
            LogUtils.writeLong(logBuffer, this.rootLsn);
        }
        LogUtils.writeLong(logBuffer, this.firstActiveLsn);
        LogUtils.writeLong(logBuffer, this.lastNodeId);
        LogUtils.writeInt(logBuffer, this.lastDbId);
        LogUtils.writeLong(logBuffer, this.lastTxnId);
        LogUtils.writeLong(logBuffer, this.id);
    }

    public void readFromLog(ByteBuffer logBuffer, byte entryTypeVersion) throws LogException {
        this.invoker = LogUtils.readString(logBuffer);
        this.endTime = LogUtils.readTimestamp(logBuffer);
        this.checkpointStartLsn = LogUtils.readLong(logBuffer);
        this.rootLsnExists = LogUtils.readBoolean(logBuffer);
        if (this.rootLsnExists) {
            this.rootLsn = LogUtils.readLong(logBuffer);
        }
        this.firstActiveLsn = LogUtils.readLong(logBuffer);
        this.lastNodeId = LogUtils.readLong(logBuffer);
        this.lastDbId = LogUtils.readInt(logBuffer);
        this.lastTxnId = LogUtils.readLong(logBuffer);
        this.id = LogUtils.readLong(logBuffer);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<CkptEnd invoker=\"").append(this.invoker);
        sb.append("\" time=\"").append(this.endTime);
        sb.append("\" lastNodeId=\"").append(this.lastNodeId);
        sb.append("\" lastDbId=\"").append(this.lastDbId);
        sb.append("\" lastTxnId=\"").append(this.lastTxnId);
        sb.append("\" id=\"").append(this.id);
        sb.append("\" rootExists=\"").append(this.rootLsnExists);
        sb.append("\">");
        sb.append("<ckptStart>");
        sb.append(DbLsn.toString(this.checkpointStartLsn));
        sb.append("</ckptStart>");
        if (this.rootLsnExists) {
            sb.append("<root>");
            sb.append(DbLsn.toString(this.rootLsn));
            sb.append("</root>");
        }
        sb.append("<firstActive>");
        sb.append(DbLsn.toString(this.firstActiveLsn));
        sb.append("</firstActive>");
        sb.append("</CkptEnd>");
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("time=").append(this.endTime);
        sb.append(" lastNodeId=").append(this.lastNodeId);
        sb.append(" lastDbId=").append(this.lastDbId);
        sb.append(" lastTxnId=").append(this.lastTxnId);
        sb.append(" id=").append(this.id);
        sb.append(" rootExists=").append(this.rootLsnExists);
        sb.append(" ckptStartLsn=").append(DbLsn.getNoFormatString(this.checkpointStartLsn));
        if (this.rootLsnExists) {
            sb.append(" root=").append(DbLsn.getNoFormatString(this.rootLsn));
        }
        sb.append(" firstActive=").append(DbLsn.getNoFormatString(this.firstActiveLsn));
        return sb.toString();
    }

    long getCheckpointStartLsn() {
        return this.checkpointStartLsn;
    }

    long getRootLsn() {
        return this.rootLsn;
    }

    long getFirstActiveLsn() {
        return this.firstActiveLsn;
    }

    long getLastNodeId() {
        return this.lastNodeId;
    }

    int getLastDbId() {
        return this.lastDbId;
    }

    long getLastTxnId() {
        return this.lastTxnId;
    }

    long getId() {
        return this.id;
    }
}

