/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.PackedOffsets;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.tree.LN;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public final class FileSummaryLN
extends LN {
    private static final String BEGIN_TAG = "<fileSummaryLN>";
    private static final String END_TAG = "</fileSummaryLN>";
    private FileSummary baseSummary;
    private TrackedFileSummary trackedSummary;
    private PackedOffsets obsoleteOffsets;
    private boolean needOffsets;
    private byte logVersion;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileSummaryLN(FileSummary baseSummary) {
        super(new byte[0]);
        if (!$assertionsDisabled && baseSummary == null) {
            throw new AssertionError();
        }
        this.baseSummary = baseSummary;
        this.obsoleteOffsets = new PackedOffsets();
        this.logVersion = (byte)-1;
    }

    public FileSummaryLN() throws DatabaseException {
        this.baseSummary = new FileSummary();
        this.obsoleteOffsets = new PackedOffsets();
    }

    public void setTrackedSummary(TrackedFileSummary trackedSummary) {
        this.trackedSummary = trackedSummary;
        this.needOffsets = true;
    }

    public TrackedFileSummary getTrackedSummary() {
        return this.trackedSummary;
    }

    public FileSummary getBaseSummary() {
        return this.baseSummary;
    }

    public PackedOffsets getObsoleteOffsets() {
        return this.obsoleteOffsets;
    }

    public boolean hasStringKey(byte[] bytes) {
        if (this.logVersion == 0 || bytes.length != 8) {
            return true;
        }
        return bytes[4] >= 48 && bytes[4] <= 57;
    }

    public long getFileNumber(byte[] bytes) {
        if (this.hasStringKey(bytes)) {
            try {
                return Long.valueOf(new String(bytes, "UTF-8"));
            }
            catch (UnsupportedEncodingException shouldNeverHappen) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)shouldNeverHappen);
                }
                return 0L;
            }
        }
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        return (long)LogUtils.readIntMSB(buf) & 0xFFFFFFFFL;
    }

    public static byte[] makePartialKey(long fileNum) {
        byte[] bytes = new byte[4];
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        LogUtils.writeIntMSB(buf, (int)fileNum);
        return bytes;
    }

    public static byte[] makeFullKey(long fileNum, int sequence) {
        if (!$assertionsDisabled && sequence < 0) {
            throw new AssertionError();
        }
        byte[] bytes = new byte[8];
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        LogUtils.writeIntMSB(buf, (int)fileNum);
        LogUtils.writeIntMSB(buf, Integer.MAX_VALUE - sequence);
        return bytes;
    }

    public void postFetchInit(DatabaseImpl db, long sourceLsn) throws DatabaseException {
        super.postFetchInit(db, sourceLsn);
        if (this.logVersion == 1 && db.getDbEnvironment().getUtilizationProfile().isRMWFixEnabled()) {
            this.obsoleteOffsets = new PackedOffsets();
        }
    }

    public String toString() {
        return this.dumpString(0, true);
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuffer sb = new StringBuffer();
        sb.append(super.dumpString(nSpaces, dumpTags));
        sb.append('\n');
        if (!this.isDeleted()) {
            sb.append(this.baseSummary.toString());
            sb.append(this.obsoleteOffsets.toString());
        }
        return sb.toString();
    }

    protected void dumpLogAdditional(StringBuffer sb, boolean verbose) {
        if (!this.isDeleted()) {
            this.baseSummary.dumpLog(sb, true);
            if (verbose) {
                this.obsoleteOffsets.dumpLog(sb, true);
            }
        }
    }

    protected LogEntryType getTransactionalLogType() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Txnl access to UP db not allowed");
        }
        return LogEntryType.LOG_FILESUMMARYLN;
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_FILESUMMARYLN;
    }

    public boolean marshallOutsideWriteLatch() {
        return false;
    }

    public boolean countAsObsoleteWhenLogged() {
        return false;
    }

    public int getLogSize() {
        int size = super.getLogSize();
        if (!this.isDeleted()) {
            size += this.baseSummary.getLogSize();
            this.getOffsets();
            size += this.obsoleteOffsets.getLogSize();
        }
        return size;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        if (this.trackedSummary != null) {
            this.baseSummary.add(this.trackedSummary);
            if (!this.isDeleted()) {
                this.getOffsets();
            }
            this.trackedSummary.reset();
        }
        super.writeToLog(logBuffer);
        if (!this.isDeleted()) {
            this.baseSummary.writeToLog(logBuffer);
            this.obsoleteOffsets.writeToLog(logBuffer);
        }
    }

    public void readFromLog(ByteBuffer itemBuffer, byte entryTypeVersion) throws LogException {
        super.readFromLog(itemBuffer, entryTypeVersion);
        this.logVersion = entryTypeVersion;
        if (!this.isDeleted()) {
            this.baseSummary.readFromLog(itemBuffer, entryTypeVersion);
            if (entryTypeVersion > 0) {
                this.obsoleteOffsets.readFromLog(itemBuffer, entryTypeVersion);
            }
        }
    }

    private void getOffsets() {
        if (this.needOffsets) {
            long[] offsets = this.trackedSummary.getObsoleteOffsets();
            if (offsets != null) {
                this.obsoleteOffsets.pack(offsets);
            }
            this.needOffsets = false;
        }
    }

    static {
        $assertionsDisabled = !FileSummaryLN.class.desiredAssertionStatus();
    }
}

