/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Locker;

public class ThreadLocker
extends BasicLocker {
    public ThreadLocker(EnvironmentImpl env) throws DatabaseException {
        super(env);
    }

    protected void checkState(boolean ignoreCalledByAbort) throws DatabaseException {
        if (this.thread != Thread.currentThread()) {
            throw new DatabaseException("A per-thread transaction was created in " + this.thread + " but used in " + Thread.currentThread());
        }
    }

    public Locker newNonTxnLocker() throws DatabaseException {
        this.checkState(false);
        return new ThreadLocker(this.envImpl);
    }

    public boolean sharesLocksWith(Locker other) {
        if (super.sharesLocksWith(other)) {
            return true;
        }
        if (other instanceof ThreadLocker) {
            return this.thread == ((ThreadLocker)other).thread;
        }
        return false;
    }
}

