/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.unmodifiable;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;

class ImmutableIterator<E>
implements Iterator<E> {
    final Object[] elements;
    int index;

    ImmutableIterator(Object[] elements) {
        this.elements = elements;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.elements.length;
    }

    @Override
    public E next() {
        if (this.hasNext()) {
            return (E)this.elements[this.index++];
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        Object[] elements = this.elements;
        int end = elements.length;
        while (this.index < end) {
            action.accept(elements[this.index++]);
        }
    }
}

