/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.tsp;

import java.io.IOException;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.tsp.Accuracy;
import org.bouncycastle.asn1.tsp.MessageImprint;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.X509Extensions;

public class TSTInfo
extends ASN1Encodable {
    DERInteger version;
    DERObjectIdentifier tsaPolicyId;
    MessageImprint messageImprint;
    DERInteger serialNumber;
    DERGeneralizedTime genTime;
    Accuracy accuracy;
    DERBoolean ordering;
    DERInteger nonce;
    GeneralName tsa;
    X509Extensions extensions;

    public static TSTInfo getInstance(Object object) {
        if (object == null || object instanceof TSTInfo) {
            return (TSTInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new TSTInfo((ASN1Sequence)object);
        }
        if (object instanceof ASN1OctetString) {
            try {
                return TSTInfo.getInstance(new ASN1InputStream(((ASN1OctetString)object).getOctets()).readObject());
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Bad object format in 'TSTInfo' factory.");
            }
        }
        throw new IllegalArgumentException("Unknown object in 'TSTInfo' factory : " + object.getClass().getName() + ".");
    }

    public TSTInfo(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.version = DERInteger.getInstance(enumeration.nextElement());
        this.tsaPolicyId = DERObjectIdentifier.getInstance(enumeration.nextElement());
        this.messageImprint = MessageImprint.getInstance(enumeration.nextElement());
        this.serialNumber = DERInteger.getInstance(enumeration.nextElement());
        this.genTime = DERGeneralizedTime.getInstance(enumeration.nextElement());
        this.ordering = new DERBoolean(false);
        while (enumeration.hasMoreElements()) {
            DERObject dERObject = (DERObject)enumeration.nextElement();
            if (dERObject instanceof ASN1TaggedObject) {
                DERTaggedObject dERTaggedObject = (DERTaggedObject)dERObject;
                switch (dERTaggedObject.getTagNo()) {
                    case 0: {
                        this.tsa = GeneralName.getInstance(dERTaggedObject, true);
                        break;
                    }
                    case 1: {
                        this.extensions = X509Extensions.getInstance(dERTaggedObject, false);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown tag value " + dERTaggedObject.getTagNo());
                    }
                }
                continue;
            }
            if (dERObject instanceof DERSequence) {
                this.accuracy = Accuracy.getInstance(dERObject);
                continue;
            }
            if (dERObject instanceof DERBoolean) {
                this.ordering = DERBoolean.getInstance(dERObject);
                continue;
            }
            if (!(dERObject instanceof DERInteger)) continue;
            this.nonce = DERInteger.getInstance(dERObject);
        }
    }

    public TSTInfo(DERObjectIdentifier dERObjectIdentifier, MessageImprint messageImprint, DERInteger dERInteger, DERGeneralizedTime dERGeneralizedTime, Accuracy accuracy, DERBoolean dERBoolean, DERInteger dERInteger2, GeneralName generalName, X509Extensions x509Extensions) {
        this.version = new DERInteger(1);
        this.tsaPolicyId = dERObjectIdentifier;
        this.messageImprint = messageImprint;
        this.serialNumber = dERInteger;
        this.genTime = dERGeneralizedTime;
        this.accuracy = accuracy;
        this.ordering = dERBoolean;
        this.nonce = dERInteger2;
        this.tsa = generalName;
        this.extensions = x509Extensions;
    }

    public MessageImprint getMessageImprint() {
        return this.messageImprint;
    }

    public DERObjectIdentifier getPolicy() {
        return this.tsaPolicyId;
    }

    public DERInteger getSerialNumber() {
        return this.serialNumber;
    }

    public Accuracy getAccuracy() {
        return this.accuracy;
    }

    public DERGeneralizedTime getGenTime() {
        return this.genTime;
    }

    public DERBoolean getOrdering() {
        return this.ordering;
    }

    public DERInteger getNonce() {
        return this.nonce;
    }

    public GeneralName getTsa() {
        return this.tsa;
    }

    public X509Extensions getExtensions() {
        return this.extensions;
    }

    @Override
    public DERObject toASN1Object() {
        DEREncodableVector dEREncodableVector = new DEREncodableVector();
        dEREncodableVector.add(this.version);
        dEREncodableVector.add(this.tsaPolicyId);
        dEREncodableVector.add(this.messageImprint);
        dEREncodableVector.add(this.serialNumber);
        dEREncodableVector.add(this.genTime);
        if (this.accuracy != null) {
            dEREncodableVector.add(this.accuracy);
        }
        if (this.ordering != null && this.ordering.isTrue()) {
            dEREncodableVector.add(this.ordering);
        }
        if (this.nonce != null) {
            dEREncodableVector.add(this.nonce);
        }
        if (this.tsa != null) {
            dEREncodableVector.add(new DERTaggedObject(true, 0, this.tsa));
        }
        if (this.extensions != null) {
            dEREncodableVector.add(new DERTaggedObject(false, 1, this.extensions));
        }
        return new DERSequence(dEREncodableVector);
    }
}

