/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.edgegrid.signer.apachehttpclient;

import com.akamai.edgegrid.signer.ClientCredential;
import com.akamai.edgegrid.signer.ClientCredentialProvider;
import com.akamai.edgegrid.signer.apachehttpclient.ApacheHttpClientEdgeGridRequestSigner;
import com.akamai.edgegrid.signer.exceptions.NoMatchingCredentialException;
import java.net.ProxySelector;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.protocol.HttpContext;

public class ApacheHttpClientEdgeGridRoutePlanner
extends SystemDefaultRoutePlanner {
    private final ApacheHttpClientEdgeGridRequestSigner binding;

    public ApacheHttpClientEdgeGridRoutePlanner(ClientCredential clientCredential) {
        this(clientCredential, ProxySelector.getDefault());
    }

    public ApacheHttpClientEdgeGridRoutePlanner(ClientCredential clientCredential, ProxySelector proxySelector) {
        super(proxySelector);
        this.binding = new ApacheHttpClientEdgeGridRequestSigner(clientCredential);
    }

    public ApacheHttpClientEdgeGridRoutePlanner(ClientCredentialProvider clientCredentialProvider) {
        this(clientCredentialProvider, ProxySelector.getDefault());
    }

    public ApacheHttpClientEdgeGridRoutePlanner(ClientCredentialProvider clientCredentialProvider, ProxySelector proxySelector) {
        super(proxySelector);
        this.binding = new ApacheHttpClientEdgeGridRequestSigner(clientCredentialProvider);
    }

    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        try {
            ClientCredential clientCredential = this.binding.getClientCredentialProvider().getClientCredential(this.binding.map(request));
            String hostname = clientCredential.getHost();
            int port = -1;
            int pos = hostname.lastIndexOf(":");
            if (pos > 0) {
                try {
                    port = Integer.parseInt(hostname.substring(pos + 1));
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Host contains invalid port number: " + hostname);
                }
                hostname = hostname.substring(0, pos);
            }
            HttpHost target = new HttpHost(hostname, port, "https");
            return super.determineRoute(target, request, context);
        }
        catch (NoMatchingCredentialException e) {
            throw new RuntimeException(e);
        }
    }
}

