/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.codec.netty;

import com.alibaba.csp.sentinel.cluster.codec.response.ResponseEntityWriter;
import com.alibaba.csp.sentinel.cluster.response.ClusterResponse;
import com.alibaba.csp.sentinel.cluster.response.Response;
import com.alibaba.csp.sentinel.cluster.server.codec.ServerEntityCodecProvider;
import com.alibaba.csp.sentinel.log.RecordLog;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;

public class NettyResponseEncoder
extends MessageToByteEncoder<ClusterResponse> {
    protected void encode(ChannelHandlerContext ctx, ClusterResponse response, ByteBuf out) throws Exception {
        ResponseEntityWriter responseEntityWriter = ServerEntityCodecProvider.getResponseEntityWriter();
        if (responseEntityWriter == null) {
            RecordLog.warn((String)"[NettyResponseEncoder] Cannot resolve the global response entity writer, reply bad status", (Object[])new Object[0]);
            this.writeBadStatusHead((Response)response, out);
            return;
        }
        responseEntityWriter.writeTo((Object)response, (Object)out);
    }

    private void writeBadStatusHead(Response response, ByteBuf out) {
        out.writeInt(response.getId());
        out.writeByte(-1);
        out.writeByte(response.getStatus());
    }
}

