/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.odps.visitor;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsCreateTableStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsInsert;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsInsertStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsSetLabelStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsShowPartitionsStmt;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsShowStatisticStmt;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsUDTFSQLSelectItem;
import com.alibaba.druid.sql.dialect.odps.visitor.OdpsASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import java.util.List;

public class OdpsOutputVisitor
extends SQLASTOutputVisitor
implements OdpsASTVisitor {
    public OdpsOutputVisitor(Appendable appender) {
        super(appender);
    }

    @Override
    public boolean visit(OdpsCreateTableStatement x) {
        int partitionSize;
        int size;
        if (x.isIfNotExiists()) {
            this.print("CREATE TABLE IF NOT EXISTS ");
        } else {
            this.print("CREATE TABLE ");
        }
        x.getName().accept(this);
        x.getName().accept(this);
        if (x.getLike() != null) {
            this.print(" LIKE ");
            x.getLike().accept(this);
        }
        if ((size = x.getTableElementList().size()) > 0) {
            this.print(" (");
            this.incrementIndent();
            this.println();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    this.print(", ");
                    this.println();
                }
                x.getTableElementList().get(i).accept(this);
            }
            this.decrementIndent();
            this.println();
            this.print(")");
        }
        if (x.getComment() != null) {
            this.println();
            this.print("COMMENT ");
            x.getComment().accept(this);
        }
        if ((partitionSize = x.getPartitionColumns().size()) > 0) {
            this.println();
            this.print("PARTITIONED (");
            for (int i = 0; i < partitionSize; ++i) {
                if (i != 0) {
                    this.print(", ");
                }
                x.getPartitionColumns().get(i).accept(this);
            }
            this.print(")");
        }
        if (x.getLifecycle() != null) {
            this.println();
            this.print("LIFECYCLE ");
            x.getLifecycle().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OdpsCreateTableStatement x) {
        super.endVisit(x);
    }

    public SQLStatement parseInsert() {
        OdpsInsertStatement stmt = new OdpsInsertStatement();
        return stmt;
    }

    @Override
    public void endVisit(OdpsInsertStatement x) {
    }

    @Override
    public boolean visit(OdpsInsertStatement x) {
        if (x.getFrom() != null) {
            this.print("FROM (");
            this.incrementIndent();
            this.println();
            x.getFrom().getSelect().accept(this);
            this.decrementIndent();
            this.println();
            this.print(") ");
            this.print(x.getFrom().getAlias());
        }
        for (OdpsInsert insert : x.getItems()) {
            this.println();
            this.println();
            insert.accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OdpsInsert x) {
    }

    @Override
    public boolean visit(OdpsInsert x) {
        if (x.isOverwrite()) {
            this.print("INSERT OVERWRITE TABLE ");
        } else {
            this.print("INSERT INTO OVERWRITE ");
        }
        x.getTableSource().accept(this);
        int partitions = x.getPartitions().size();
        if (partitions > 0) {
            this.print(" PARTITION (");
            for (int i = 0; i < partitions; ++i) {
                if (i != 0) {
                    this.print(", ");
                }
                SQLAssignItem assign = x.getPartitions().get(i);
                assign.getTarget().accept(this);
                if (assign.getValue() == null) continue;
                this.print("=");
                assign.getValue().accept(this);
            }
            this.print(")");
        }
        this.println();
        x.getQuery().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCaseExpr x) {
        this.incrementIndent();
        this.print("CASE ");
        if (x.getValueExpr() != null) {
            x.getValueExpr().accept(this);
            this.println();
        }
        this.printAndAccept(x.getItems(), " ");
        if (x.getElseExpr() != null) {
            this.println();
            this.print("ELSE ");
            x.getElseExpr().accept(this);
        }
        this.println();
        this.print("END");
        this.decrementIndent();
        return false;
    }

    @Override
    public boolean visit(SQLSelectGroupByClause x) {
        int itemSize = x.getItems().size();
        if (itemSize > 0) {
            this.print("GROUP BY ");
            this.incrementIndent();
            for (int i = 0; i < itemSize; ++i) {
                if (i != 0) {
                    this.println(", ");
                }
                x.getItems().get(i).accept(this);
            }
            this.decrementIndent();
        }
        if (x.getHaving() != null) {
            this.println();
            this.print("HAVING ");
            x.getHaving().accept(this);
        }
        return false;
    }

    @Override
    protected void printSelectList(List<SQLSelectItem> selectList) {
        this.incrementIndent();
        int size = selectList.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(", ");
                this.println();
            }
            selectList.get(i).accept(this);
        }
        this.decrementIndent();
    }

    @Override
    public boolean visit(SQLSubqueryTableSource x) {
        this.print("(");
        this.incrementIndent();
        this.println();
        x.getSelect().accept(this);
        this.decrementIndent();
        this.println();
        this.print(")");
        if (x.getAlias() != null) {
            this.print(' ');
            this.print(x.getAlias());
        }
        return false;
    }

    @Override
    public boolean visit(SQLJoinTableSource x) {
        x.getLeft().accept(this);
        if (x.getJoinType() == SQLJoinTableSource.JoinType.COMMA) {
            this.print(",");
        } else {
            this.println();
            this.print(SQLJoinTableSource.JoinType.toString(x.getJoinType()));
        }
        this.print(" ");
        x.getRight().accept(this);
        if (x.getCondition() != null) {
            this.incrementIndent();
            this.print(" ON ");
            x.getCondition().accept(this);
            this.decrementIndent();
        }
        if (x.getUsing().size() > 0) {
            this.print(" USING (");
            this.printAndAccept(x.getUsing(), ", ");
            this.print(")");
        }
        if (x.getAlias() != null) {
            this.print(" AS ");
            this.print(x.getAlias());
        }
        return false;
    }

    @Override
    public void endVisit(OdpsUDTFSQLSelectItem x) {
    }

    @Override
    public boolean visit(OdpsUDTFSQLSelectItem x) {
        x.getExpr().accept(this);
        this.print(" AS (");
        for (int i = 0; i < x.getAliasList().size(); ++i) {
            if (i != 0) {
                this.print(", ");
            }
            this.print(x.getAliasList().get(i));
        }
        this.print(")");
        return false;
    }

    @Override
    public void endVisit(OdpsShowPartitionsStmt x) {
    }

    @Override
    public boolean visit(OdpsShowPartitionsStmt x) {
        this.print("SHOW PARTITIONS ");
        x.getTableSource().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsShowStatisticStmt x) {
    }

    @Override
    public boolean visit(OdpsShowStatisticStmt x) {
        this.print("SHOW STATISTIC ");
        x.getTableSource().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsSetLabelStatement x) {
    }

    @Override
    public boolean visit(OdpsSetLabelStatement x) {
        this.print("SET LABEL ");
        this.print(x.getLabel());
        this.print(" TO ");
        if (x.getUser() != null) {
            this.print("USER ");
            x.getUser().accept(this);
        } else if (x.getTable() != null) {
            this.print("TABLE ");
            x.getTable().accept(this);
            if (x.getColumns().size() > 0) {
                this.print("(");
                this.printAndAccept(x.getColumns(), ", ");
                this.print(")");
            }
        }
        return false;
    }
}

