/*
 * Decompiled with CFR 0.152.
 */
package com.amihaiemil.eoyaml;

import com.amihaiemil.eoyaml.AllYamlLines;
import com.amihaiemil.eoyaml.Backwards;
import com.amihaiemil.eoyaml.BaseFoldedScalar;
import com.amihaiemil.eoyaml.Comment;
import com.amihaiemil.eoyaml.FirstCommentFound;
import com.amihaiemil.eoyaml.GreaterIndentation;
import com.amihaiemil.eoyaml.ReadComment;
import com.amihaiemil.eoyaml.Skip;
import com.amihaiemil.eoyaml.YamlLine;
import com.amihaiemil.eoyaml.YamlLines;
import java.util.ArrayList;
import java.util.List;

final class ReadFoldedBlockScalar
extends BaseFoldedScalar {
    private final YamlLine previous;
    private final AllYamlLines all;
    private final YamlLines significant;

    ReadFoldedBlockScalar(AllYamlLines lines) {
        this(new YamlLine.NullYamlLine(), lines);
    }

    ReadFoldedBlockScalar(YamlLine previous, AllYamlLines lines) {
        this.previous = previous;
        this.all = lines;
        this.significant = new GreaterIndentation(previous, new Skip(lines, line -> line.number() <= previous.number(), line -> line.trimmed().endsWith(">"), line -> line.trimmed().startsWith("---"), line -> line.trimmed().startsWith("..."), line -> line.trimmed().startsWith("%"), line -> line.trimmed().startsWith("!!")));
    }

    private boolean doNotEndWithNewLine(StringBuilder builder) {
        return builder.length() > 0 && !builder.toString().endsWith(System.lineSeparator());
    }

    @Override
    public String value() {
        StringBuilder builder = new StringBuilder();
        String newLine = System.lineSeparator();
        for (YamlLine line : this.significant) {
            if (line.trimmed().length() == 0 || line.indentation() > 0) {
                if (this.doNotEndWithNewLine(builder)) {
                    builder.append(newLine);
                }
                int indentation = line.indentation();
                for (int i = 0; i < indentation; ++i) {
                    builder.append(' ');
                }
                builder.append(line.trimmed());
                builder.append(newLine);
                continue;
            }
            if (this.doNotEndWithNewLine(builder)) {
                builder.append(' ');
            }
            builder.append(line.trimmed());
        }
        return builder.toString();
    }

    @Override
    public Comment comment() {
        return new ReadComment(new Backwards(new FirstCommentFound(new Backwards(new Skip(this.all, line -> {
            boolean skip = this.previous.number() < 0 ? (this.significant.iterator().hasNext() ? line.number() >= this.significant.iterator().next().number() : false) : line.number() >= this.previous.number();
            return skip;
        }, line -> line.trimmed().startsWith("---"), line -> line.trimmed().startsWith("..."), line -> line.trimmed().startsWith("%"), line -> line.trimmed().startsWith("!!"))))), this);
    }

    @Override
    List<String> unfolded() {
        ArrayList<String> unfolded = new ArrayList<String>();
        for (YamlLine line : this.significant) {
            unfolded.add(line.toString());
        }
        return unfolded;
    }
}

