/*
 * Decompiled with CFR 0.152.
 */
package com.amihaiemil.eoyaml;

import com.amihaiemil.eoyaml.AllYamlLines;
import com.amihaiemil.eoyaml.Backwards;
import com.amihaiemil.eoyaml.BaseYamlStream;
import com.amihaiemil.eoyaml.FirstCommentFound;
import com.amihaiemil.eoyaml.Skip;
import com.amihaiemil.eoyaml.StartMarkers;
import com.amihaiemil.eoyaml.WellIndented;
import com.amihaiemil.eoyaml.YamlLine;
import com.amihaiemil.eoyaml.YamlLines;
import com.amihaiemil.eoyaml.YamlNode;
import java.util.ArrayList;
import java.util.Collection;

final class ReadYamlStream
extends BaseYamlStream {
    private final YamlLines all;
    private final YamlLines startMarkers;
    private final boolean guessIndentation;

    ReadYamlStream(AllYamlLines lines) {
        this(lines, false);
    }

    ReadYamlStream(AllYamlLines lines, boolean guessIndentation) {
        this.startMarkers = new WellIndented(new StartMarkers(new Skip(lines, line -> line.trimmed().startsWith("#"), line -> line.trimmed().startsWith("%"))));
        this.all = new Skip(lines, line -> line.trimmed().startsWith("%"));
        this.guessIndentation = guessIndentation;
    }

    @Override
    public Collection<YamlNode> values() {
        ArrayList<YamlNode> values = new ArrayList<YamlNode>();
        for (YamlLine startDoc : this.startMarkers) {
            YamlLines document = this.readDocument(startDoc);
            if (document.original().isEmpty()) continue;
            values.add(document.toYamlNode(startDoc, this.guessIndentation));
        }
        return values;
    }

    private YamlLines readDocument(YamlLine start) {
        ArrayList<YamlLine> yamlDocLines = new ArrayList<YamlLine>();
        Backwards docComment = new Backwards(new FirstCommentFound(new Backwards(new Skip(this.all, line -> line.number() > start.number())), true));
        for (YamlLine line2 : docComment) {
            yamlDocLines.add(line2);
        }
        for (YamlLine line2 : this.all) {
            if (line2.number() <= start.number()) continue;
            String current = line2.trimmed();
            if ("---".equals(current) || "...".equals(current)) break;
            yamlDocLines.add(line2);
        }
        return new AllYamlLines(yamlDocLines);
    }
}

