/*
 * Decompiled with CFR 0.152.
 */
package com.amihaiemil.eoyaml;

import com.amihaiemil.eoyaml.BaseYamlSequence;
import com.amihaiemil.eoyaml.Comment;
import com.amihaiemil.eoyaml.Yaml;
import com.amihaiemil.eoyaml.YamlNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

final class ReflectedYamlSequence
extends BaseYamlSequence {
    private final Collection<Object> sequence;

    ReflectedYamlSequence(Object sequence) {
        if (sequence instanceof Collection) {
            this.sequence = (Collection)sequence;
        } else if (sequence.getClass().isArray()) {
            Object[] array = (Object[])sequence;
            this.sequence = Arrays.asList(array);
        } else {
            throw new IllegalArgumentException("YamlSequence can only be reflected from a Collection or from an array.");
        }
    }

    @Override
    public Collection<YamlNode> values() {
        ArrayList<YamlNode> values = new ArrayList<YamlNode>();
        for (Object value : this.sequence) {
            values.add(Yaml.createYamlDump(value).dump());
        }
        return values;
    }

    @Override
    public Comment comment() {
        return new Comment(){

            @Override
            public YamlNode yamlNode() {
                return ReflectedYamlSequence.this;
            }

            @Override
            public String value() {
                return "";
            }
        };
    }
}

