/*
 * Decompiled with CFR 0.152.
 */
package com.amihaiemil.eoyaml;

import com.amihaiemil.eoyaml.YamlLine;
import com.amihaiemil.eoyaml.exceptions.YamlReadingException;

final class RtYamlLine
implements YamlLine {
    private String value;
    private int number;

    RtYamlLine(String value, int number) {
        this.value = value;
        this.number = number;
    }

    @Override
    public String trimmed() {
        String trimmed = this.value.trim();
        for (int i = 0; i < trimmed.length(); ++i) {
            if (i > 0 && trimmed.charAt(i) == '#') {
                trimmed = trimmed.substring(0, i);
                break;
            }
            if (trimmed.charAt(i) == '\"') {
                ++i;
                while (i < trimmed.length() && trimmed.charAt(i) != '\"') {
                    ++i;
                }
                continue;
            }
            if (trimmed.charAt(i) != '\'') continue;
            ++i;
            while (i < trimmed.length() && trimmed.charAt(i) != '\'') {
                ++i;
            }
        }
        return trimmed.trim();
    }

    @Override
    public String contents(int previousIndent) {
        String contents;
        int indentation = this.indentation();
        if (indentation == 0 && previousIndent <= 0) {
            contents = this.value;
        } else if (indentation > previousIndent) {
            contents = this.value.substring(previousIndent + 2);
        } else {
            throw new YamlReadingException("Literal must be indented at least 2 spaces from previous element.");
        }
        return contents;
    }

    @Override
    public String comment() {
        String comment = "";
        String trimmed = this.value.trim();
        for (int i = 0; i < trimmed.length(); ++i) {
            if (trimmed.charAt(i) == '#') {
                comment = trimmed.substring(i + 1);
                break;
            }
            if (trimmed.charAt(i) == '\"') {
                ++i;
                while (i < trimmed.length() && trimmed.charAt(i) != '\"') {
                    ++i;
                }
                continue;
            }
            if (trimmed.charAt(i) != '\'') continue;
            ++i;
            while (i < trimmed.length() && trimmed.charAt(i) != '\'') {
                ++i;
            }
        }
        return comment.trim();
    }

    @Override
    public int number() {
        return this.number;
    }

    @Override
    public int indentation() {
        int index;
        for (index = 0; index < this.value.length() && this.value.charAt(index) == ' '; ++index) {
        }
        return index;
    }

    public String toString() {
        return this.value;
    }

    @Override
    public int compareTo(YamlLine other) {
        int result = -1;
        result = this == other ? 0 : (other == null ? 1 : this.trimmed().compareTo(other.trimmed()));
        return result;
    }

    @Override
    public boolean requireNestedIndentation() {
        boolean result;
        if ("---".equals(this.trimmed())) {
            result = false;
        } else {
            String specialCharacters = ":>|-?";
            String prevLineLastChar = this.trimmed().substring(this.trimmed().length() - 1);
            result = ":>|-?".contains(prevLineLastChar);
        }
        return result;
    }
}

