/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.process.hooks;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.output.v1.Event;
import com.appland.appmap.process.hooks.ProxyHooks;
import com.appland.appmap.transform.annotations.HookClass;
import com.appland.appmap.transform.annotations.MethodEvent;
import com.appland.shade.org.tinylog.Supplier;
import com.appland.shade.org.tinylog.TaggedLogger;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class Proxy {
    static final TaggedLogger logger = AppMapConfig.getLogger(null);
    private static final Map<Method, ProxyHooks> allProxyHooks = new HashMap<Method, ProxyHooks>();

    @HookClass(value="java.lang.reflect.InvocationHandler")
    public static void invoke(Event event, Object receiver, Object proxy, Method method, Object[] methodArgs) {
        Supplier[] supplierArray = new Supplier[4];
        supplierArray[0] = receiver::toString;
        supplierArray[1] = proxy::toString;
        supplierArray[2] = () -> String.format("%s@%x", method, method.hashCode());
        supplierArray[3] = () -> methodArgs != null ? methodArgs.toString() : "null";
        logger.trace("receiver: {}, proxy: {}, method: {}, method args: {}", supplierArray);
        ProxyHooks proxyHooks = allProxyHooks.get(method);
        if (proxyHooks == null) {
            proxyHooks = ProxyHooks.build(method, methodArgs);
        }
        if (proxyHooks == null) {
            return;
        }
        allProxyHooks.put(method, proxyHooks);
        proxyHooks.invokeCall(proxy, method, methodArgs);
    }

    @HookClass(value="java.lang.reflect.InvocationHandler", method="invoke", methodEvent=MethodEvent.METHOD_RETURN)
    public static void invokeReturn(Event event, Object receiver, Object ret, Object proxy, Method method, Object[] methodArgs) {
        Supplier[] supplierArray = new Supplier[4];
        supplierArray[0] = receiver::toString;
        supplierArray[1] = proxy::toString;
        supplierArray[2] = () -> String.format("%s@%x", method, method.hashCode());
        supplierArray[3] = () -> methodArgs != null ? methodArgs.toString() : "null";
        logger.trace("receiver: {}, proxy: {}, method: {}, method args: {}", supplierArray);
        ProxyHooks proxyHooks = allProxyHooks.get(method);
        if (proxyHooks != null) {
            proxyHooks.invokeReturn(proxy, ret, methodArgs);
        }
    }

    @HookClass(value="java.lang.reflect.InvocationHandler", method="invoke", methodEvent=MethodEvent.METHOD_EXCEPTION)
    public static void invokeExc(Event event, Object receiver, Throwable exc, Object proxy, Method method, Object[] methodArgs) {
        Supplier[] supplierArray = new Supplier[4];
        supplierArray[0] = receiver::toString;
        supplierArray[1] = proxy::toString;
        supplierArray[2] = () -> String.format("%s@%x", method, method.hashCode());
        supplierArray[3] = () -> methodArgs != null ? methodArgs.toString() : "null";
        logger.trace("receiver: {}, proxy: {}, method: {}, method args: {}", supplierArray);
        ProxyHooks proxyHooks = allProxyHooks.get(method);
        if (proxyHooks != null) {
            proxyHooks.invokeExc(proxy, exc, methodArgs);
        }
    }
}

