/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.process.hooks;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.output.v1.Event;
import com.appland.appmap.process.ExitEarly;
import com.appland.appmap.process.hooks.RequestRecording;
import com.appland.appmap.process.hooks.http.HttpServerRequest;
import com.appland.appmap.process.hooks.remoterecording.RemoteRecordingManager;
import com.appland.appmap.process.hooks.remoterecording.ServletRequest;
import com.appland.appmap.reflect.DynamicReflectiveType;
import com.appland.appmap.reflect.HttpServletRequest;
import com.appland.appmap.reflect.HttpServletResponse;
import com.appland.appmap.reflect.ReflectiveType;
import com.appland.appmap.transform.annotations.ArgumentArray;
import com.appland.appmap.transform.annotations.HookClass;
import com.appland.appmap.util.ClassUtil;
import com.appland.shade.org.tinylog.TaggedLogger;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class Spark {
    private static final TaggedLogger logger = AppMapConfig.getLogger(null);

    @HookClass(value="org.eclipse.jetty.server.handler.HandlerWrapper")
    @ArgumentArray
    public static void setHandler(Event event, Object receiver, Object[] args) {
        if (!receiver.getClass().getName().equals("org.eclipse.jetty.server.Server")) {
            return;
        }
        Object handler = args[0];
        if (!Spark.isSparkHandler(handler)) {
            return;
        }
        HandlerWrapper server = new HandlerWrapper(receiver);
        logger.trace("handler: {}", handler);
        server.setHandler(Handler.build(handler));
        throw new ExitEarly();
    }

    private static boolean isSparkHandler(Object handler) {
        String jettyHandlerClass;
        String argClass = handler.getClass().getName();
        if (argClass.equals(jettyHandlerClass = "spark.embeddedserver.jetty.JettyHandler")) {
            return true;
        }
        if (argClass.equals("org.eclipse.jetty.server.handler.HandlerList")) {
            HandlerList hl = new HandlerList(handler);
            return Arrays.stream(hl.getHandlers()).anyMatch(h -> h.getClass().getName().equals(jettyHandlerClass));
        }
        return false;
    }

    private static class HandlerList
    extends ReflectiveType {
        private static String GET_HANDLERS = "getHandlers";

        public HandlerList(Object self) {
            super(self);
            this.addMethods(GET_HANDLERS);
        }

        public Object[] getHandlers() {
            return (Object[])this.invokeObjectMethod(GET_HANDLERS, new Object[0]);
        }
    }

    private static class Handler
    extends DynamicReflectiveType
    implements InvocationHandler {
        private Object wrapper;

        private Handler(Object wrapper) {
            this.wrapper = wrapper;
        }

        static Object build(Object handler) {
            ClassLoader cl = handler.getClass().getClassLoader();
            try {
                Object wrapper = ClassUtil.safeClassForName(cl, "org.eclipse.jetty.server.handler.HandlerWrapper").getConstructor(new Class[0]).newInstance(new Object[0]);
                new HandlerWrapper(wrapper).setHandler(handler);
                return DynamicReflectiveType.build(new Handler(wrapper), cl, "org.eclipse.jetty.server.Handler");
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                logger.error(e);
                throw new InternalError(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            if (name.equals("handle")) {
                JettyRequest jettyReq = new JettyRequest(args[1]);
                HttpServletRequest req = new HttpServletRequest(args[2]);
                HttpServletResponse resp = new HttpServletResponse(args[3]);
                String requestURI = req.getRequestURI();
                logger.trace("handling {}", requestURI);
                if (requestURI.equals("/_appmap/record") && RemoteRecordingManager.service(new ServletRequest(req, resp))) {
                    jettyReq.setHandled(true);
                    return null;
                }
                RequestRecording.start(req);
                Event http_server_request = Event.functionCallEvent();
                HttpServerRequest.recordHttpServerRequest(http_server_request, req);
                try {
                    method.invoke(this.wrapper, args);
                    req.setAttribute(HttpServerRequest.STATUS_ATTRIBUTE, resp.getStatus());
                    Event http_server_response = Event.functionReturnEvent();
                    HttpServerRequest.recordHttpServerResponse(http_server_response, req, resp);
                    Object var11_11 = null;
                    return var11_11;
                }
                finally {
                    RequestRecording.stop(req);
                }
            }
            logger.trace("wrapper: {}, invoking {}", this.wrapper, method);
            return method.invoke(this.wrapper, args);
        }
    }

    private static class JettyRequest
    extends ReflectiveType {
        private static String SET_HANDLED = "setHandled";

        public JettyRequest(Object self) {
            super(self);
            this.addMethod(SET_HANDLED, Boolean.TYPE);
        }

        public void setHandled(boolean handled) {
            this.invokeVoidMethod(SET_HANDLED, handled);
        }
    }

    private static class HandlerWrapper
    extends ReflectiveType {
        private static String SET_HANDLER = "setHandler";

        public HandlerWrapper(Object self) {
            super(self);
            this.addMethod(SET_HANDLER, "org.eclipse.jetty.server.Handler");
        }

        public void setHandler(Object handler) {
            this.invokeVoidMethod(SET_HANDLER, handler);
        }
    }
}

