/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.process.hooks.test;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.output.v1.Event;
import com.appland.appmap.process.hooks.RecordingSupport;
import com.appland.appmap.process.hooks.test.TestSupport;
import com.appland.appmap.record.Recorder;
import com.appland.appmap.reflect.ReflectiveType;
import com.appland.appmap.transform.annotations.ArgumentArray;
import com.appland.appmap.transform.annotations.ExcludeReceiver;
import com.appland.appmap.transform.annotations.HookAnnotated;
import com.appland.appmap.transform.annotations.HookClass;
import com.appland.appmap.transform.annotations.MethodEvent;
import com.appland.shade.org.tinylog.TaggedLogger;

public class TestNG {
    private static final TaggedLogger logger = AppMapConfig.getLogger(null);
    private static final String TESTNG_NAME = "testng";
    private static final Recorder recorder = Recorder.getInstance();
    private static final ThreadLocal<Event> lastReturnEvent = new ThreadLocal();

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="org.testng.annotations.Test")
    public static void testng(Event event, Object[] args) {
        TestSupport.startRecording(event, new Recorder.Metadata(TESTNG_NAME, "tests"));
        lastReturnEvent.set(null);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookAnnotated(value="org.testng.annotations.Test", methodEvent=MethodEvent.METHOD_RETURN)
    public static void testng(Event event, Object returnValue, Object[] args) {
        lastReturnEvent.set(event);
    }

    @ArgumentArray
    @HookAnnotated(value="org.testng.annotations.Test", methodEvent=MethodEvent.METHOD_EXCEPTION)
    public static void testng(Event event, Object self, Throwable exception, Object[] args) {
        lastReturnEvent.set(event);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookClass(value="org.testng.internal.ExitCodeListener")
    public static void onTestSuccess(Event listenerEvent, Object[] listenerArgs) {
        Event event = lastReturnEvent.get();
        logger.debug("retEvent: {}", event);
        if (event == null) {
            logger.warn((Throwable)new Exception(), "no return event set for thread {}", Thread.currentThread().getName());
            return;
        }
        RecordingSupport.stopRecording(event, true);
    }

    @ArgumentArray
    @HookClass(value="org.testng.internal.ExitCodeListener")
    public static void onTestFailure(Event listenerEvent, Object listener, Object[] listenerArgs) {
        Event event = lastReturnEvent.get();
        logger.debug("retEvent: {}", event);
        if (event == null) {
            logger.warn((Throwable)new Exception(), "no return event set for thread {}", Thread.currentThread().getName());
            return;
        }
        ITestResult testResult = new ITestResult(listenerArgs[0]);
        Object self = testResult.getInstance();
        Throwable exception = testResult.getThrowable();
        event.setException(exception);
        StackTraceElement ste = TestSupport.findErrorFrame(self, exception);
        RecordingSupport.stopRecording(new RecordingSupport.TestDetails(event), false, exception.getMessage(), ste.getLineNumber());
    }

    private static class ITestResult
    extends ReflectiveType {
        private static final String GET_INSTANCE = "getInstance";
        private static String GET_THROWABLE = "getThrowable";

        public ITestResult(Object self) {
            super(self);
            this.addMethods(GET_INSTANCE, GET_THROWABLE);
        }

        public Object getInstance() {
            return this.invokeObjectMethod(GET_INSTANCE, new Object[0]);
        }

        public Throwable getThrowable() {
            return (Throwable)this.invokeObjectMethod(GET_THROWABLE, new Object[0]);
        }
    }
}

