/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.record;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.output.v1.CodeObject;
import com.appland.appmap.output.v1.Event;
import com.appland.appmap.output.v1.Value;
import com.appland.appmap.record.Recorder;
import com.appland.appmap.record.UnknownEventException;
import com.appland.shade.javassist.CtBehavior;
import com.appland.shade.org.tinylog.TaggedLogger;
import java.util.ArrayList;
import java.util.List;

public class EventTemplateRegistry {
    private static final TaggedLogger logger = AppMapConfig.getLogger(null);
    private static final EventTemplateRegistry instance = new EventTemplateRegistry();
    private static final Recorder recorder = Recorder.getInstance();
    private final List<Event> eventTemplates = new ArrayList<Event>();

    private EventTemplateRegistry() {
    }

    public static EventTemplateRegistry get() {
        return instance;
    }

    public Integer register(CtBehavior behavior, String[] labels) {
        Event event = new Event(behavior);
        return this.register(event, behavior, labels);
    }

    public synchronized Integer register(Event event, CtBehavior behavior, String[] labels) {
        recorder.registerCodeObject(CodeObject.createTree(behavior, labels));
        this.eventTemplates.add(event);
        return this.eventTemplates.size() - 1;
    }

    public Event getTemplate(Integer templateId) {
        try {
            return this.eventTemplates.get(templateId);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public Event buildCallEvent(int templateId) {
        Event eventTemplate = this.lookupEventTemplate(templateId);
        Event event = Event.functionCallEvent(eventTemplate);
        for (Value param : eventTemplate.parameters) {
            event.addParameter(param);
        }
        return event;
    }

    public Event buildReturnEvent(int templateId) {
        Event eventTemplate = this.lookupEventTemplate(templateId);
        return Event.functionReturnEvent(eventTemplate);
    }

    Event lookupEventTemplate(int templateId) {
        try {
            return this.eventTemplates.get(templateId);
        }
        catch (IndexOutOfBoundsException e) {
            logger.warn((Throwable)e, "unknown template for ordinal {} - have we been loaded by a non-system class loader?", templateId);
            throw new UnknownEventException("unknown template ordinal");
        }
    }
}

