/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.transform.annotations;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.process.conditions.Condition;
import com.appland.appmap.transform.annotations.HookCondition;
import com.appland.appmap.transform.annotations.ISystem;
import com.appland.appmap.transform.annotations.SourceMethodSystem;
import com.appland.shade.javassist.CtBehavior;
import com.appland.shade.org.tinylog.TaggedLogger;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class HookConditionSystem
extends SourceMethodSystem {
    private static final TaggedLogger logger = AppMapConfig.getLogger(null);
    private static final Map<Class<? extends Condition>, Condition> conditions = new HashMap<Class<? extends Condition>, Condition>();
    private Condition condition;

    private HookConditionSystem(CtBehavior behavior, Condition condition) {
        super(behavior, HookCondition.class);
        this.condition = Objects.requireNonNull(condition);
    }

    public static ISystem from(CtBehavior behavior) {
        try {
            HookCondition hookCondition = (HookCondition)behavior.getAnnotation(HookCondition.class);
            if (hookCondition == null) {
                hookCondition = (HookCondition)behavior.getDeclaringClass().getAnnotation(HookCondition.class);
            }
            if (hookCondition == null) {
                return null;
            }
            Class<? extends Condition> conditionClass = hookCondition.value();
            if (conditionClass == null) {
                return null;
            }
            return new HookConditionSystem(behavior, conditions.computeIfAbsent(conditionClass, c -> {
                try {
                    return (Condition)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    logger.warn(e);
                    return null;
                }
            }));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Boolean match(CtBehavior behavior, Map<String, Object> mapResult) {
        return this.condition.match(behavior, mapResult);
    }

    @Override
    public Integer getHookPosition() {
        return 0;
    }
}

