/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.eclipse.jgit.api;

import com.appland.shade.org.eclipse.jgit.api.GitCommand;
import com.appland.shade.org.eclipse.jgit.api.errors.GitAPIException;
import com.appland.shade.org.eclipse.jgit.api.errors.JGitInternalException;
import com.appland.shade.org.eclipse.jgit.api.errors.RefNotFoundException;
import com.appland.shade.org.eclipse.jgit.internal.JGitText;
import com.appland.shade.org.eclipse.jgit.lib.ObjectId;
import com.appland.shade.org.eclipse.jgit.lib.Ref;
import com.appland.shade.org.eclipse.jgit.lib.Repository;
import com.appland.shade.org.eclipse.jgit.revwalk.RevCommit;
import com.appland.shade.org.eclipse.jgit.revwalk.RevWalk;
import com.appland.shade.org.eclipse.jgit.revwalk.RevWalkUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ListBranchCommand
extends GitCommand<List<Ref>> {
    private ListMode listMode;
    private String containsCommitish;

    protected ListBranchCommand(Repository repo) {
        super(repo);
    }

    @Override
    public List<Ref> call() throws GitAPIException {
        ArrayList<Ref> resultRefs;
        this.checkCallable();
        try {
            ArrayList<Ref> refs = new ArrayList<Ref>();
            Ref head = this.repo.exactRef("HEAD");
            if (head != null && head.getLeaf().getName().equals("HEAD")) {
                refs.add(head);
            }
            if (this.listMode == null) {
                refs.addAll(this.repo.getRefDatabase().getRefsByPrefix("refs/heads/"));
            } else if (this.listMode == ListMode.REMOTE) {
                refs.addAll(this.repo.getRefDatabase().getRefsByPrefix("refs/remotes/"));
            } else {
                refs.addAll(this.repo.getRefDatabase().getRefsByPrefix("refs/heads/", "refs/remotes/"));
            }
            resultRefs = new ArrayList<Ref>(this.filterRefs(refs));
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        Collections.sort(resultRefs, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        this.setCallable(false);
        return resultRefs;
    }

    private Collection<Ref> filterRefs(Collection<Ref> refs) throws RefNotFoundException, IOException {
        if (this.containsCommitish == null) {
            return refs;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (RevWalk walk = new RevWalk(this.repo);){
            ObjectId resolved = this.repo.resolve(this.containsCommitish);
            if (resolved == null) {
                throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.containsCommitish));
            }
            RevCommit containsCommit = walk.parseCommit(resolved);
            return RevWalkUtils.findBranchesReachableFrom(containsCommit, walk, refs);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public ListBranchCommand setListMode(ListMode listMode) {
        this.checkCallable();
        this.listMode = listMode;
        return this;
    }

    public ListBranchCommand setContains(String containsCommitish) {
        this.checkCallable();
        this.containsCommitish = containsCommitish;
        return this;
    }

    public static enum ListMode {
        ALL,
        REMOTE;

    }
}

