/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.eclipse.jgit.api;

import com.appland.shade.org.eclipse.jgit.api.AddCommand;
import com.appland.shade.org.eclipse.jgit.api.CloneCommand;
import com.appland.shade.org.eclipse.jgit.api.Git;
import com.appland.shade.org.eclipse.jgit.api.TransportCommand;
import com.appland.shade.org.eclipse.jgit.api.errors.GitAPIException;
import com.appland.shade.org.eclipse.jgit.api.errors.JGitInternalException;
import com.appland.shade.org.eclipse.jgit.api.errors.NoFilepatternException;
import com.appland.shade.org.eclipse.jgit.errors.ConfigInvalidException;
import com.appland.shade.org.eclipse.jgit.internal.JGitText;
import com.appland.shade.org.eclipse.jgit.internal.submodule.SubmoduleValidator;
import com.appland.shade.org.eclipse.jgit.lib.ProgressMonitor;
import com.appland.shade.org.eclipse.jgit.lib.Repository;
import com.appland.shade.org.eclipse.jgit.lib.StoredConfig;
import com.appland.shade.org.eclipse.jgit.storage.file.FileBasedConfig;
import com.appland.shade.org.eclipse.jgit.submodule.SubmoduleWalk;
import com.appland.shade.org.eclipse.jgit.treewalk.filter.PathFilter;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;

public class SubmoduleAddCommand
extends TransportCommand<SubmoduleAddCommand, Repository> {
    private String name;
    private String path;
    private String uri;
    private ProgressMonitor monitor;

    public SubmoduleAddCommand(Repository repo) {
        super(repo);
    }

    public SubmoduleAddCommand setName(String name) {
        this.name = name;
        return this;
    }

    public SubmoduleAddCommand setPath(String path) {
        this.path = path;
        return this;
    }

    public SubmoduleAddCommand setURI(String uri) {
        this.uri = uri;
        return this;
    }

    public SubmoduleAddCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    protected boolean submoduleExists() throws IOException {
        PathFilter filter = PathFilter.create(this.path);
        Throwable throwable = null;
        Object var3_4 = null;
        try (SubmoduleWalk w = SubmoduleWalk.forIndex(this.repo);){
            return w.setFilter(filter).next();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Repository call() throws GitAPIException {
        String resolvedUri;
        this.checkCallable();
        if (this.path == null || this.path.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().pathNotConfigured);
        }
        if (this.uri == null || this.uri.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().uriNotConfigured);
        }
        if (this.name == null || this.name.length() == 0) {
            this.name = this.path;
        }
        try {
            SubmoduleValidator.assertValidSubmoduleName(this.name);
            SubmoduleValidator.assertValidSubmodulePath(this.path);
            SubmoduleValidator.assertValidSubmoduleUri(this.uri);
        }
        catch (SubmoduleValidator.SubmoduleValidationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        try {
            if (this.submoduleExists()) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().submoduleExists, this.path));
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        try {
            resolvedUri = SubmoduleWalk.getSubmoduleRemoteUrl(this.repo, this.uri);
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        File moduleDirectory = SubmoduleWalk.getSubmoduleDirectory(this.repo, this.path);
        CloneCommand clone = Git.cloneRepository();
        this.configure(clone);
        clone.setDirectory(moduleDirectory);
        clone.setGitDir(new File(new File(this.repo.getDirectory(), "modules"), this.path));
        clone.setURI(resolvedUri);
        if (this.monitor != null) {
            clone.setProgressMonitor(this.monitor);
        }
        Repository subRepo = null;
        Throwable throwable = null;
        Object var6_10 = null;
        try (Git git = clone.call();){
            subRepo = git.getRepository();
            subRepo.incrementOpen();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        StoredConfig config = this.repo.getConfig();
        config.setString("submodule", this.name, "url", resolvedUri);
        try {
            config.save();
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        FileBasedConfig modulesConfig = new FileBasedConfig(new File(this.repo.getWorkTree(), ".gitmodules"), this.repo.getFS());
        try {
            modulesConfig.load();
            modulesConfig.setString("submodule", this.name, "path", this.path);
            modulesConfig.setString("submodule", this.name, "url", this.uri);
            modulesConfig.save();
        }
        catch (ConfigInvalidException | IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        AddCommand add = new AddCommand(this.repo);
        add.addFilepattern(".gitmodules");
        add.addFilepattern(this.path);
        try {
            add.call();
        }
        catch (NoFilepatternException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        return subRepo;
    }
}

