/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.eclipse.jgit.hooks;

import com.appland.shade.org.eclipse.jgit.hooks.CommitMsgHook;
import com.appland.shade.org.eclipse.jgit.hooks.PostCommitHook;
import com.appland.shade.org.eclipse.jgit.hooks.PreCommitHook;
import com.appland.shade.org.eclipse.jgit.hooks.PrePushHook;
import com.appland.shade.org.eclipse.jgit.internal.JGitText;
import com.appland.shade.org.eclipse.jgit.lib.Repository;
import com.appland.shade.org.eclipse.jgit.util.LfsFactory;
import java.io.PrintStream;
import java.text.MessageFormat;

public class Hooks {
    public static PreCommitHook preCommit(Repository repo, PrintStream outputStream) {
        return new PreCommitHook(repo, outputStream);
    }

    public static PreCommitHook preCommit(Repository repo, PrintStream outputStream, PrintStream errorStream) {
        return new PreCommitHook(repo, outputStream, errorStream);
    }

    public static PostCommitHook postCommit(Repository repo, PrintStream outputStream) {
        return new PostCommitHook(repo, outputStream);
    }

    public static PostCommitHook postCommit(Repository repo, PrintStream outputStream, PrintStream errorStream) {
        return new PostCommitHook(repo, outputStream, errorStream);
    }

    public static CommitMsgHook commitMsg(Repository repo, PrintStream outputStream) {
        return new CommitMsgHook(repo, outputStream);
    }

    public static CommitMsgHook commitMsg(Repository repo, PrintStream outputStream, PrintStream errorStream) {
        return new CommitMsgHook(repo, outputStream, errorStream);
    }

    public static PrePushHook prePush(Repository repo, PrintStream outputStream) {
        PrePushHook hook;
        if (LfsFactory.getInstance().isAvailable() && (hook = LfsFactory.getInstance().getPrePushHook(repo, outputStream)) != null) {
            if (hook.isNativeHookPresent()) {
                PrintStream ps = outputStream;
                if (ps == null) {
                    ps = System.out;
                }
                ps.println(MessageFormat.format(JGitText.get().lfsHookConflict, repo));
            }
            return hook;
        }
        return new PrePushHook(repo, outputStream);
    }

    public static PrePushHook prePush(Repository repo, PrintStream outputStream, PrintStream errorStream) {
        PrePushHook hook;
        if (LfsFactory.getInstance().isAvailable() && (hook = LfsFactory.getInstance().getPrePushHook(repo, outputStream, errorStream)) != null) {
            if (hook.isNativeHookPresent()) {
                PrintStream ps = outputStream;
                if (ps == null) {
                    ps = System.out;
                }
                ps.println(MessageFormat.format(JGitText.get().lfsHookConflict, repo));
            }
            return hook;
        }
        return new PrePushHook(repo, outputStream, errorStream);
    }
}

