/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.eclipse.jgit.internal.submodule;

import com.appland.shade.org.eclipse.jgit.errors.ConfigInvalidException;
import com.appland.shade.org.eclipse.jgit.internal.JGitText;
import com.appland.shade.org.eclipse.jgit.lib.Config;
import com.appland.shade.org.eclipse.jgit.lib.ObjectChecker;
import java.text.MessageFormat;

public class SubmoduleValidator {
    public static void assertValidSubmoduleName(String name) throws SubmoduleValidationException {
        if (name.contains("/../") || name.contains("\\..\\") || name.startsWith("../") || name.startsWith("..\\") || name.endsWith("/..") || name.endsWith("\\..")) {
            throw new SubmoduleValidationException(MessageFormat.format(JGitText.get().invalidNameContainsDotDot, name), ObjectChecker.ErrorType.GITMODULES_NAME);
        }
        if (name.startsWith("-")) {
            throw new SubmoduleValidationException(MessageFormat.format(JGitText.get().submoduleNameInvalid, name), ObjectChecker.ErrorType.GITMODULES_NAME);
        }
    }

    public static void assertValidSubmoduleUri(String uri) throws SubmoduleValidationException {
        if (uri.startsWith("-")) {
            throw new SubmoduleValidationException(MessageFormat.format(JGitText.get().submoduleUrlInvalid, uri), ObjectChecker.ErrorType.GITMODULES_URL);
        }
    }

    public static void assertValidSubmodulePath(String path) throws SubmoduleValidationException {
        if (path.startsWith("-")) {
            throw new SubmoduleValidationException(MessageFormat.format(JGitText.get().submodulePathInvalid, path), ObjectChecker.ErrorType.GITMODULES_PATH);
        }
    }

    public static void assertValidGitModulesFile(String gitModulesContents) throws SubmoduleValidationException {
        Config c = new Config();
        try {
            c.fromText(gitModulesContents);
            for (String subsection : c.getSubsections("submodule")) {
                String path;
                SubmoduleValidator.assertValidSubmoduleName(subsection);
                String url = c.getString("submodule", subsection, "url");
                if (url != null) {
                    SubmoduleValidator.assertValidSubmoduleUri(url);
                }
                if ((path = c.getString("submodule", subsection, "path")) == null) continue;
                SubmoduleValidator.assertValidSubmodulePath(path);
            }
        }
        catch (ConfigInvalidException e) {
            SubmoduleValidationException sve = new SubmoduleValidationException(JGitText.get().invalidGitModules, ObjectChecker.ErrorType.GITMODULES_PARSE);
            sve.initCause(e);
            throw sve;
        }
    }

    public static class SubmoduleValidationException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final ObjectChecker.ErrorType fsckMessageId;

        SubmoduleValidationException(String message, ObjectChecker.ErrorType fsckMessageId) {
            super(message);
            this.fsckMessageId = fsckMessageId;
        }

        public ObjectChecker.ErrorType getFsckMessageId() {
            return this.fsckMessageId;
        }
    }
}

