/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.eclipse.jgit.revwalk;

import com.appland.shade.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import com.appland.shade.org.eclipse.jgit.errors.MissingObjectException;
import com.appland.shade.org.eclipse.jgit.errors.StopWalkException;
import com.appland.shade.org.eclipse.jgit.lib.ObjectId;
import com.appland.shade.org.eclipse.jgit.revwalk.DateRevQueue;
import com.appland.shade.org.eclipse.jgit.revwalk.Generator;
import com.appland.shade.org.eclipse.jgit.revwalk.RevCommit;
import com.appland.shade.org.eclipse.jgit.revwalk.RevWalk;
import com.appland.shade.org.eclipse.jgit.revwalk.filter.RevFilter;
import java.io.IOException;

class PendingGenerator
extends Generator {
    private static final int PARSED = 1;
    private static final int SEEN = 2;
    private static final int UNINTERESTING = 4;
    static final int OVER_SCAN = 6;
    private static final RevCommit INIT_LAST = new RevCommit(ObjectId.zeroId());
    private final RevWalk walker;
    private final DateRevQueue pending;
    private final RevFilter filter;
    private final int output;
    private RevCommit last = INIT_LAST;
    private int overScan = 6;
    boolean canDispose;

    static {
        PendingGenerator.INIT_LAST.commitTime = Integer.MAX_VALUE;
    }

    PendingGenerator(RevWalk w, DateRevQueue p, RevFilter f, int out) {
        super(w.isFirstParent());
        this.walker = w;
        this.pending = p;
        this.filter = f;
        this.output = out;
        this.canDispose = true;
    }

    @Override
    int outputType() {
        return this.output | 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        try {
            while (true) {
                boolean produce;
                RevCommit c;
                block13: {
                    block15: {
                        block14: {
                            if ((c = this.pending.next()) == null) {
                                return null;
                            }
                            if ((c.flags & 4) != 0) {
                                produce = false;
                            } else {
                                if (this.filter.requiresCommitBody()) {
                                    c.parseBody(this.walker);
                                }
                                produce = this.filter.include(this.walker, c);
                            }
                            int i = 0;
                            while (true) {
                                if (i >= c.parents.length) {
                                    this.walker.carryFlagsImpl(c);
                                    if ((c.flags & 4) == 0) break block13;
                                    if (!this.pending.everbodyHasFlag(4)) break block14;
                                    RevCommit n = this.pending.peek();
                                    if (n == null || n.commitTime < this.last.commitTime) break;
                                    this.overScan = 6;
                                    break block15;
                                }
                                RevCommit p = c.parents[i];
                                if (!(this.firstParent && i > 0 && (c.flags & 4) == 0 || (p.flags & 2) != 0)) {
                                    if ((p.flags & 1) == 0) {
                                        p.parseHeaders(this.walker);
                                    }
                                    p.flags |= 2;
                                    this.pending.add(p);
                                }
                                ++i;
                            }
                            if (--this.overScan == 0) {
                                throw StopWalkException.INSTANCE;
                            }
                            break block15;
                        }
                        this.overScan = 6;
                    }
                    if (!this.canDispose) continue;
                    c.disposeBody();
                    continue;
                }
                if (produce) {
                    this.last = c;
                    return this.last;
                }
                if (!this.canDispose) continue;
                c.disposeBody();
            }
        }
        catch (StopWalkException swe) {
            this.pending.clear();
            return null;
        }
    }
}

