/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.config.Properties;
import com.appland.appmap.process.hooks.MethodCall;
import com.appland.appmap.process.hooks.MethodReturn;
import com.appland.appmap.record.Recorder;
import com.appland.appmap.record.Recording;
import com.appland.appmap.runtime.HookFunctions;
import com.appland.appmap.transform.ClassFileTransformer;
import com.appland.appmap.transform.annotations.HookFactory;
import com.appland.appmap.transform.instrumentation.BBTransformer;
import com.appland.appmap.util.GitUtil;
import com.appland.shade.javassist.CtClass;
import com.appland.shade.org.apache.commons.io.FilenameUtils;
import com.appland.shade.org.apache.commons.io.IOUtils;
import com.appland.shade.org.tinylog.TaggedLogger;
import com.appland.shade.org.tinylog.provider.ProviderRegistry;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.instrument.Instrumentation;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Agent {
    public static final TaggedLogger logger = AppMapConfig.getLogger(null);

    public static void premain(String agentArgs, Instrumentation inst) {
        long start = System.currentTimeMillis();
        try {
            AppMapConfig.initialize(FileSystems.getDefault());
        }
        catch (IOException e) {
            logger.warn((Throwable)e, "Initialization failed");
            System.exit(1);
        }
        if (Properties.DisableLogFile == null) {
            logger.info("To disable the automatic creation of this log file, set the system property {} to 'true'", "appmap.disableLogFile");
        }
        logger.info("Agent version {}, current time mills: {}", Agent.class.getPackage().getImplementationVersion(), start);
        logger.info("config: {}", AppMapConfig.get());
        logger.info("System properties: {}", System.getProperties());
        logger.debug((Throwable)new Exception(), "whereAmI");
        Agent.addAgentJars(agentArgs, inst);
        if (!Properties.DisableGit.booleanValue()) {
            try {
                GitUtil.findSourceRoots();
                logger.debug("done finding source roots, {}", () -> {
                    long now = System.currentTimeMillis();
                    return String.format("%d, %d", now - start, start);
                });
            }
            catch (IOException e) {
                logger.warn(e);
            }
        }
        if (Properties.SaveInstrumented.booleanValue()) {
            CtClass.debugDump = Paths.get(System.getProperty("java.io.tmpdir"), "appmap", "ja").toString();
            logger.info("Saving instrumented files to {}", CtClass.debugDump);
        }
        ClassFileTransformer methodCallTransformer = new ClassFileTransformer("method call", HookFactory.APP_HOOKS_FACTORY);
        inst.addTransformer(methodCallTransformer);
        BBTransformer.installOn(inst);
        ClassFileTransformer systemHookTransformer = new ClassFileTransformer("system hook", HookFactory.AGENT_HOOKS_FACTORY);
        inst.addTransformer(systemHookTransformer);
        Runnable logShutdown = () -> {
            try {
                ClassFileTransformer.logStatistics();
                ProviderRegistry.getLoggingProvider().shutdown();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        };
        if (Properties.RecordingAuto.booleanValue()) {
            Agent.startAutoRecording(logShutdown);
        } else {
            Runtime.getRuntime().addShutdownHook(new Thread(logShutdown));
        }
    }

    private static void startAutoRecording(Runnable logShutdown) {
        String appmapName = Properties.RecordingName;
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmss");
        String timestamp = dateFormat.format(date);
        Recorder.Metadata metadata = new Recorder.Metadata("java", "process");
        Recorder recorder = Recorder.getInstance();
        if (appmapName == null || appmapName.trim().isEmpty()) {
            appmapName = timestamp;
        }
        metadata.scenarioName = appmapName;
        recorder.start(metadata);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            String fileName = Properties.RecordingFile;
            if (fileName == null || fileName.trim().isEmpty()) {
                fileName = String.format("%s.appmap.json", timestamp);
            }
            Recording recording = recorder.stop();
            recording.moveTo(fileName);
            logShutdown.run();
        }));
    }

    private static void addAgentJars(String agentArgs, Instrumentation inst) {
        Path agentJarPath = null;
        try {
            Class<Agent> agentClass = Agent.class;
            URL resourceURL = agentClass.getClassLoader().getResource(agentClass.getName().replace('.', '/') + ".class");
            if (resourceURL.getProtocol().equals("jar")) {
                String resourcePath = resourceURL.getPath();
                URL jarURL = new URL(resourcePath.substring(0, resourcePath.indexOf(33)));
                logger.debug("jarURL: {}", jarURL);
                agentJarPath = Paths.get(jarURL.toURI());
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            logger.error((Throwable)e, "Failed getting path to agent jar");
            System.exit(1);
        }
        if (agentJarPath != null) {
            try {
                JarFile agentJar = new JarFile(agentJarPath.toFile());
                inst.appendToSystemClassLoaderSearch(agentJar);
                Agent.setupRuntime(agentJarPath, agentJar, inst);
            }
            catch (IOException | IllegalArgumentException | SecurityException e) {
                logger.error((Throwable)e, "Failed loading agent jars");
                System.exit(1);
            }
        }
    }

    private static void setupRuntime(Path agentJarPath, JarFile agentJar, Instrumentation inst) throws IOException, FileNotFoundException {
        Path runtimeJarPath = null;
        Enumeration<JarEntry> entries = agentJar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.startsWith("runtime-")) continue;
            Path installDir = agentJarPath.getParent();
            runtimeJarPath = installDir.resolve(FilenameUtils.getBaseName(entryName) + ".jar");
            if (Files.exists(runtimeJarPath, new LinkOption[0])) break;
            IOUtils.copy(agentJar.getInputStream(entry), (OutputStream)new FileOutputStream(runtimeJarPath.toFile()));
            break;
        }
        if (runtimeJarPath == null) {
            logger.error("Couldn't find runtime jar in {}", runtimeJarPath);
            System.exit(1);
        }
        JarFile runtimeJar = new JarFile(runtimeJarPath.toFile());
        inst.appendToSystemClassLoaderSearch(runtimeJar);
        HookFunctions.onMethodCall = MethodCall::onCall;
        HookFunctions.onMethodReturn = MethodReturn::onReturn;
    }
}

