/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.process.hooks.http;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.output.v1.Event;
import com.appland.appmap.record.Recorder;
import com.appland.appmap.reflect.apache.HttpRequest;
import com.appland.appmap.reflect.apache.HttpResponse;
import com.appland.appmap.reflect.apache.HttpUriRequest;
import com.appland.appmap.reflect.apache.NameValuePair;
import com.appland.appmap.reflect.apache.URIBuilder;
import com.appland.appmap.transform.annotations.ArgumentArray;
import com.appland.appmap.transform.annotations.ExcludeReceiver;
import com.appland.appmap.transform.annotations.HookClass;
import com.appland.appmap.transform.annotations.MethodEvent;
import com.appland.appmap.transform.annotations.Signature;
import com.appland.appmap.transform.annotations.Signatures;
import com.appland.appmap.transform.annotations.Unique;
import com.appland.shade.org.tinylog.TaggedLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;

@Unique(value="http_client_request")
public class HttpClientRequest {
    private static final TaggedLogger logger = AppMapConfig.getLogger(null);
    private static final Recorder recorder = Recorder.getInstance();

    @ArgumentArray
    @ExcludeReceiver
    @HookClass(value="org.apache.http.client.HttpClient")
    @Signatures(value={@Signature(value={"org.apache.http.client.methods.HttpUriRequest"}), @Signature(value={"org.apache.http.client.methods.HttpUriRequest", "org.apache.http.protocol.HttpContext"})})
    public static void execute(Event event, Object[] args) {
        HttpUriRequest req = new HttpUriRequest(args[0]);
        URIBuilder builder = HttpClientRequest.newBuilder(req.getURI());
        HttpClientRequest.execute(event, req.getMethod(), builder);
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookClass(value="org.apache.http.client.HttpClient", method="execute")
    @Signatures(value={@Signature(value={"org.apache.http.HttpHost", "org.apache.http.HttpRequest"}), @Signature(value={"org.apache.http.HttpHost", "org.apache.http.HttpRequest", "org.apache.http.protocol.HttpContext"})})
    public static void executeOnHost(Event event, Object[] args) {
        HttpRequest req = new HttpRequest(args[1]);
        try {
            URI hostURI = new URI(args[0].toString());
            URIBuilder builder = HttpClientRequest.newBuilder(new URI(req.getUri())).setScheme(hostURI.getScheme()).setHost(hostURI.getHost()).setPort(hostURI.getPort());
            HttpClientRequest.execute(event, req.getMethod(), builder);
        }
        catch (URISyntaxException e) {
            logger.warn((Throwable)e, "req: {}");
        }
    }

    private static void execute(Event event, String method, URIBuilder builder) {
        List<?> params = builder.getQueryParams();
        String noQuery = builder.removeQuery().build().toString();
        event.setHttpClientRequest(method, noQuery);
        event.setParameters(null);
        for (Object param : params) {
            NameValuePair nvp = new NameValuePair(param);
            event.addMessageParam(nvp.getName(), nvp.getValue());
        }
        recorder.add(event);
    }

    private static URIBuilder newBuilder(URI uri) {
        try {
            Class<?> cls = Class.forName("org.apache.http.client.utils.URIBuilder", true, Thread.currentThread().getContextClassLoader());
            Constructor<?> ctor = cls.getConstructor(URI.class);
            return new URIBuilder(ctor.newInstance(uri));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.error((Throwable)e, "failed creating a URIBuilder");
            throw new InternalError(e);
        }
    }

    @ArgumentArray
    @ExcludeReceiver
    @HookClass(value="org.apache.http.client.HttpClient", methodEvent=MethodEvent.METHOD_RETURN)
    @Signatures(value={@Signature(value={"org.apache.http.client.methods.HttpUriRequest"}), @Signature(value={"org.apache.http.client.methods.HttpUriRequest", "org.apache.http.protocol.HttpContext"}), @Signature(value={"org.apache.http.HttpHost", "org.apache.http.HttpRequest"}), @Signature(value={"org.apache.http.HttpHost", "org.apache.http.HttpRequest", "org.apache.http.protocol.HttpContext"})})
    public static void execute(Event event, Object ret, Object[] args) {
        HttpResponse res = new HttpResponse(ret);
        event.setHttpClientResponse(res.getStatusCode(), res.getContentType());
        event.setParameters(null);
        recorder.add(event);
    }
}

