/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.process.hooks.remoterecording;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.process.ExitEarly;
import com.appland.appmap.process.hooks.remoterecording.RemoteRecordingRequest;
import com.appland.appmap.record.Recorder;
import com.appland.appmap.record.Recording;
import com.appland.shade.org.tinylog.TaggedLogger;
import java.io.IOException;
import java.time.OffsetDateTime;

public class RemoteRecordingManager {
    private static final TaggedLogger logger = AppMapConfig.getLogger(null);
    private static final Recorder recorder = Recorder.getInstance();
    public static final String RecordRoute = "/_appmap/record";
    public static final String CheckpointRoute = "/_appmap/record/checkpoint";

    private static void doDelete(RemoteRecordingRequest req) throws IOException {
        logger.trace("req: {}", req);
        if (!recorder.hasActiveSession()) {
            req.setStatus(404);
            return;
        }
        Recording recording = recorder.stop();
        req.writeRecording(recording);
        req.setStatus(200);
    }

    private static void doGet(RemoteRecordingRequest req) throws IOException {
        logger.trace("req: {}", req);
        String responseJson = String.format("{\"enabled\":%b}", recorder.hasActiveSession());
        req.writeJson(responseJson);
        req.setStatus(200);
    }

    private static void doPost(RemoteRecordingRequest req) {
        logger.trace("req: {}", req);
        if (recorder.hasActiveSession()) {
            logger.trace("recording in progress");
            req.setStatus(409);
            return;
        }
        Recorder.Metadata metadata = new Recorder.Metadata("remote_recording", "remote");
        metadata.scenarioName = String.format("Remote Recording - %s", Recording.RECORDING_TIME_FORMATTER.format(OffsetDateTime.now()));
        recorder.start(metadata);
        req.setStatus(200);
        logger.trace("recording started");
    }

    private static void doCheckpoint(RemoteRecordingRequest req) throws IOException {
        logger.trace("req: {}");
        if (!recorder.hasActiveSession()) {
            req.setStatus(404);
            return;
        }
        Recording recording = recorder.checkpoint();
        req.writeRecording(recording);
        req.setStatus(200);
    }

    private static void handleRecordRequest(RemoteRecordingRequest req, HandlerFunction fn) throws ExitEarly {
        try {
            fn.call(req);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean service(RemoteRecordingRequest req) {
        boolean handled = false;
        String method = req.getMethod();
        String requestURI = req.getRequestURI();
        logger.debug("req: {}", () -> String.format("%s %s", method, requestURI));
        if (requestURI.endsWith(CheckpointRoute)) {
            if (method.equals("GET")) {
                RemoteRecordingManager.handleRecordRequest(req, RemoteRecordingManager::doCheckpoint);
                handled = true;
            }
        } else if (requestURI.endsWith(RecordRoute)) {
            if (method.equals("GET")) {
                RemoteRecordingManager.handleRecordRequest(req, RemoteRecordingManager::doGet);
                handled = true;
            } else if (method.equals("POST")) {
                RemoteRecordingManager.handleRecordRequest(req, RemoteRecordingManager::doPost);
                handled = true;
            } else if (method.equals("DELETE")) {
                RemoteRecordingManager.handleRecordRequest(req, RemoteRecordingManager::doDelete);
                handled = true;
            }
        }
        logger.debug("handled appmap request? {}", handled);
        return handled;
    }

    static interface HandlerFunction {
        public void call(RemoteRecordingRequest var1) throws IOException;
    }
}

