/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.transform.annotations;

import com.appland.appmap.transform.annotations.ArgumentArraySystem;
import com.appland.appmap.transform.annotations.ExcludeReceiverSystem;
import com.appland.appmap.transform.annotations.Hook;
import com.appland.appmap.transform.annotations.HookAnnotatedSystem;
import com.appland.appmap.transform.annotations.HookClassSystem;
import com.appland.appmap.transform.annotations.HookConditionSystem;
import com.appland.appmap.transform.annotations.ISystem;
import com.appland.appmap.transform.annotations.SourceMethodSystem;
import com.appland.appmap.util.Logger;
import com.appland.shade.javassist.CtBehavior;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class HookFactory {
    private static final List<Function<CtBehavior, ISystem>> AGENT_METHOD_FACTORIES = new ArrayList<Function<CtBehavior, ISystem>>(){
        {
            this.add(HookAnnotatedSystem::from);
            this.add(HookClassSystem::from);
        }
    };
    private static final List<Function<CtBehavior, ISystem>> APP_METHOD_FACTORIES = new ArrayList<Function<CtBehavior, ISystem>>(){
        {
            this.add(HookConditionSystem::from);
        }
    };
    private static final List<Function<CtBehavior, ISystem>> ALL_METHOD_FACTORIES = new ArrayList<Function<CtBehavior, ISystem>>(){
        {
            this.addAll(AGENT_METHOD_FACTORIES);
            this.addAll(APP_METHOD_FACTORIES);
        }
    };
    public static final HookFactory AGENT_HOOKS_FACTORY = new HookFactory(AGENT_METHOD_FACTORIES);
    public static final HookFactory APP_HOOKS_FACTORY = new HookFactory(APP_METHOD_FACTORIES);
    public static final HookFactory ALL_HOOKS_FACTORY = new HookFactory(ALL_METHOD_FACTORIES);
    private List<Function<CtBehavior, ISystem>> requiredHookSystemFactories = new ArrayList<Function<CtBehavior, ISystem>>();
    private static final List<Function<CtBehavior, ISystem>> optionalSystemFactories = new ArrayList<Function<CtBehavior, ISystem>>(){
        {
            this.add(ExcludeReceiverSystem::from);
            this.add(ArgumentArraySystem::from);
        }
    };

    private HookFactory(List<Function<CtBehavior, ISystem>> hookSystemFactories) {
        this.requiredHookSystemFactories.addAll(hookSystemFactories);
    }

    public Hook from(CtBehavior hookBehavior) {
        Function<CtBehavior, ISystem> factoryFn2;
        SourceMethodSystem sourceSystem = null;
        Iterator<Function<CtBehavior, ISystem>> iterator = this.requiredHookSystemFactories.iterator();
        while (iterator.hasNext() && (sourceSystem = (SourceMethodSystem)(factoryFn2 = iterator.next()).apply(hookBehavior)) == null) {
        }
        if (sourceSystem == null) {
            return null;
        }
        List<ISystem> optionalSystems = optionalSystemFactories.stream().map(factoryFn -> (ISystem)factoryFn.apply(hookBehavior)).filter(Objects::nonNull).collect(Collectors.toList());
        Hook hook = new Hook(sourceSystem, optionalSystems, hookBehavior);
        for (ISystem optionalSystem : optionalSystems) {
            if (optionalSystem.validate(hook).booleanValue()) continue;
            Logger.println("hook " + hook + " failed validation from " + optionalSystem.getClass().getSimpleName());
            return null;
        }
        return hook;
    }
}

