/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.tinylog.pattern;

import com.appland.shade.org.tinylog.core.LogEntry;
import com.appland.shade.org.tinylog.core.LogEntryValue;
import com.appland.shade.org.tinylog.pattern.Token;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;

final class FileNameToken
implements Token {
    FileNameToken() {
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return Collections.singleton(LogEntryValue.FILE);
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        String fileName = logEntry.getFileName();
        if (fileName == null) {
            builder.append("<unknown>");
        } else {
            builder.append(fileName);
        }
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        statement.setString(index, logEntry.getFileName());
    }
}

