/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.tinylog.writers;

import com.appland.shade.org.tinylog.Level;
import com.appland.shade.org.tinylog.core.LogEntry;
import com.appland.shade.org.tinylog.core.LogEntryValue;
import com.appland.shade.org.tinylog.pattern.FormatPatternParser;
import com.appland.shade.org.tinylog.pattern.Token;
import com.appland.shade.org.tinylog.provider.InternalLogger;
import com.appland.shade.org.tinylog.writers.AbstractWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public final class JdbcWriter
extends AbstractWriter {
    private static final String FIELD_PREFIX = "field.";
    private static final long MAX_BATCH_SIZE = 100L;
    private static final long MIN_RETRY_INTERVAL = 1000L;
    private final String url = this.getUrl();
    private final String user = this.getStringValue("user");
    private final String password = this.getStringValue("password");
    private final boolean reconnect = this.getBooleanValue("reconnect");
    private final boolean batch = this.getBooleanValue("batch");
    private final Object mutex = this.getBooleanValue("writingthread") ? null : new Object();
    private final String sql;
    private final List<Token> tokens;
    private final List<LogEntry> entries = new ArrayList<LogEntry>();
    private Connection connection = JdbcWriter.connect(this.url, this.user, this.password);
    private PreparedStatement statement;
    private long lostCount;
    private long reconnectTimestamp;

    public JdbcWriter() throws NamingException, SQLException {
        this(Collections.emptyMap());
    }

    public JdbcWriter(Map<String, String> properties) throws NamingException, SQLException {
        super(properties);
        this.sql = JdbcWriter.renderSql(properties, this.connection.getMetaData().getIdentifierQuoteString());
        this.statement = this.connection.prepareStatement(this.sql);
        this.tokens = JdbcWriter.createTokens(properties);
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        EnumSet<LogEntryValue> values = EnumSet.noneOf(LogEntryValue.class);
        for (Token token : this.tokens) {
            values.addAll(token.getRequiredLogEntryValues());
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(LogEntry logEntry) throws SQLException {
        if (this.mutex == null) {
            this.doWrite(logEntry);
        } else {
            Object object = this.mutex;
            synchronized (object) {
                this.doWrite(logEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws SQLException {
        if (this.batch) {
            if (this.mutex == null) {
                this.doFlush();
            } else {
                Object object = this.mutex;
                synchronized (object) {
                    this.doFlush();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.mutex == null) {
            this.doClose();
        } else {
            Object object = this.mutex;
            synchronized (object) {
                this.doClose();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doWrite(LogEntry logEntry) throws SQLException {
        if (this.checkConnection()) {
            if (this.batch) {
                this.entries.add(logEntry);
            }
            try {
                this.applyLogEntry(logEntry);
            }
            catch (SQLException ex) {
                this.resetConnection();
                throw ex;
            }
            try {
                if (this.batch) {
                    this.statement.addBatch();
                    if ((long)this.entries.size() < 100L) return;
                    this.statement.executeBatch();
                    this.entries.clear();
                    return;
                }
                this.statement.executeUpdate();
                return;
            }
            catch (SQLException ex) {
                this.resetConnection();
                throw ex;
            }
        }
        if (this.batch && (long)this.entries.size() < 100L) {
            this.entries.add(logEntry);
            return;
        } else {
            ++this.lostCount;
        }
    }

    private void doFlush() throws SQLException {
        if (this.entries.size() > 0) {
            try {
                this.statement.executeBatch();
                this.entries.clear();
            }
            catch (SQLException ex) {
                this.resetConnection();
                throw ex;
            }
        }
    }

    private void doClose() throws SQLException {
        try {
            if (this.batch) {
                this.doFlush();
            }
        }
        finally {
            if (!this.entries.isEmpty()) {
                this.lostCount += (long)this.entries.size();
            }
            if (this.lostCount > 0L) {
                InternalLogger.log(Level.ERROR, "Lost log entries due to broken database connection: " + this.lostCount);
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
    }

    private boolean checkConnection() {
        if (this.connection == null) {
            if (System.currentTimeMillis() >= this.reconnectTimestamp) {
                long start = System.currentTimeMillis();
                try {
                    this.connection = JdbcWriter.connect(this.url, this.user, this.password);
                    this.statement = this.connection.prepareStatement(this.sql);
                    if (!this.entries.isEmpty()) {
                        for (LogEntry entry : this.entries) {
                            this.applyLogEntry(entry);
                            this.statement.addBatch();
                        }
                        this.statement.executeBatch();
                        this.entries.clear();
                    }
                    if (this.lostCount > 0L) {
                        InternalLogger.log(Level.ERROR, "Lost log entries due to broken database connection: " + this.lostCount);
                        this.lostCount = 0L;
                    }
                    return true;
                }
                catch (NamingException ex) {
                    long now = System.currentTimeMillis();
                    this.reconnectTimestamp = now + Math.max(1000L, (now - start) * 2L);
                    this.closeConnectionSilently();
                    return false;
                }
                catch (SQLException ex) {
                    long now = System.currentTimeMillis();
                    this.reconnectTimestamp = now + Math.max(1000L, (now - start) * 2L);
                    this.closeConnectionSilently();
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    private void resetConnection() {
        if (this.reconnect) {
            this.closeConnectionSilently();
            this.statement = null;
            this.lostCount = this.batch ? 0L : 1L;
            this.reconnectTimestamp = 0L;
        }
    }

    private void closeConnectionSilently() {
        if (this.connection != null) {
            try {
                try {
                    this.connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            finally {
                this.connection = null;
            }
        }
    }

    private void applyLogEntry(LogEntry logEntry) throws SQLException {
        for (int i = 0; i < this.tokens.size(); ++i) {
            this.tokens.get(i).apply(logEntry, this.statement, i + 1);
        }
    }

    private static Connection connect(String url, String user, String password) throws NamingException, SQLException {
        if (url.toLowerCase(Locale.ROOT).startsWith("java:")) {
            DataSource source = (DataSource)new InitialContext().lookup(url);
            if (user == null) {
                return source.getConnection();
            }
            return source.getConnection(user, password);
        }
        if (user == null) {
            return DriverManager.getConnection(url);
        }
        return DriverManager.getConnection(url, user, password);
    }

    private String getUrl() {
        String url = this.getStringValue("url");
        if (url == null) {
            throw new IllegalArgumentException("URL is missing for JDBC writer");
        }
        return url;
    }

    private static String getTable(Map<String, String> properties) {
        String table = properties.get("table");
        if (table == null) {
            throw new IllegalArgumentException("Name of database table is missing for JDBC writer");
        }
        return table;
    }

    private static String renderSql(Map<String, String> properties, String quote) throws SQLException {
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ");
        if (properties.get("schema") != null) {
            JdbcWriter.append(builder, properties.get("schema"), quote);
            builder.append(".");
        }
        JdbcWriter.append(builder, JdbcWriter.getTable(properties), quote);
        builder.append(" (");
        int count = 0;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            if (!key.toLowerCase(Locale.ROOT).startsWith(FIELD_PREFIX)) continue;
            String column = key.substring(FIELD_PREFIX.length());
            if (count++ != 0) {
                builder.append(", ");
            }
            JdbcWriter.append(builder, column, quote);
        }
        builder.append(") VALUES (");
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                builder.append(", ?");
                continue;
            }
            builder.append("?");
        }
        builder.append(")");
        return builder.toString();
    }

    private static void append(StringBuilder builder, String identifier, String quote) throws SQLException {
        if (identifier.indexOf(10) >= 0 || identifier.indexOf(13) >= 0) {
            throw new SQLException("Identifier contains line breaks: " + identifier);
        }
        if (" ".equals(quote)) {
            for (int i = 0; i < identifier.length(); ++i) {
                char c = identifier.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '_' || c == '@' || c == '$' || c == '#') continue;
                throw new SQLException("Illegal identifier: " + identifier);
            }
            builder.append(identifier);
        } else {
            builder.append(quote).append(identifier.replace(quote, quote + quote)).append(quote);
        }
    }

    private static List<Token> createTokens(Map<String, String> properties) {
        FormatPatternParser parser = new FormatPatternParser(properties.get("exception"));
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (!entry.getKey().toLowerCase(Locale.ROOT).startsWith(FIELD_PREFIX)) continue;
            tokens.add(parser.parse(entry.getValue()));
        }
        return tokens;
    }
}

