/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.process.hooks;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.output.v1.Event;
import com.appland.appmap.process.hooks.MethodCall;
import com.appland.appmap.process.hooks.MethodException;
import com.appland.appmap.process.hooks.MethodReturn;
import com.appland.appmap.record.EventTemplateRegistry;
import com.appland.appmap.transform.ClassFileTransformer;
import com.appland.appmap.transform.annotations.HookFactory;
import com.appland.appmap.transform.annotations.HookSite;
import com.appland.appmap.transform.annotations.MethodEvent;
import com.appland.appmap.util.AppMapClassPool;
import com.appland.appmap.util.ClassUtil;
import com.appland.appmap.util.FullyQualifiedName;
import com.appland.shade.javassist.CtMethod;
import com.appland.shade.javassist.NotFoundException;
import com.appland.shade.org.tinylog.Supplier;
import com.appland.shade.org.tinylog.TaggedLogger;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ProxyHooks {
    private static final TaggedLogger logger = AppMapConfig.getLogger(null);
    static final ClassFileTransformer transformer = new ClassFileTransformer("proxy hooks", HookFactory.ALL_HOOKS_FACTORY);
    private final HookSite callHook;
    private final HookSite returnHook;
    private final HookSite excHook;

    private ProxyHooks(List<HookSite> hookSites) {
        this.callHook = Objects.requireNonNull(hookSites.get(MethodEvent.METHOD_INVOCATION.getIndex()));
        this.returnHook = Objects.requireNonNull(hookSites.get(MethodEvent.METHOD_RETURN.getIndex()));
        this.excHook = Objects.requireNonNull(hookSites.get(MethodEvent.METHOD_EXCEPTION.getIndex()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ProxyHooks build(Method method, Object[] methodArgs) {
        FullyQualifiedName fqn = new FullyQualifiedName(method);
        if (AppMapConfig.get().includes(fqn) == null) {
            return null;
        }
        AppMapClassPool.acquire(Thread.currentThread().getContextClassLoader());
        try {
            String[] argTypes = (String[])Arrays.stream(method.getParameterTypes()).map(a -> a.getName()).toArray(String[]::new);
            CtMethod behavior = ClassUtil.getDeclaredMethod(method.getDeclaringClass().getName(), method.getName(), argTypes);
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = method::toString;
            supplierArray[1] = method::toGenericString;
            supplierArray[2] = behavior::getLongName;
            logger.trace("method: '{},'{}' behavior: {}", supplierArray);
            List<HookSite> hookSites = transformer.getHookSites(behavior);
            logger.trace("hookSites: {}", hookSites);
            if (hookSites == null) {
                ProxyHooks proxyHooks = null;
                return proxyHooks;
            }
            Supplier[] supplierArray2 = new Supplier[4];
            supplierArray2[0] = hookSites::size;
            supplierArray2[1] = method::toString;
            supplierArray2[2] = method::toGenericString;
            supplierArray2[3] = behavior::getLongName;
            logger.debug("{} hooks for method: '{},'{}' behavior: {}", supplierArray2);
            ProxyHooks proxyHooks = new ProxyHooks(hookSites);
            return proxyHooks;
        }
        catch (NotFoundException e) {
            logger.warn(e);
        }
        finally {
            AppMapClassPool.release();
        }
        return null;
    }

    void invokeCall(Object proxy, Method method, Object[] methodArgs) {
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = this.callHook::toString;
        supplierArray[1] = this.callHook::getMethodEvent;
        supplierArray[2] = method::getName;
        logger.trace("callHook: {}, method event: {}, method: {}", supplierArray);
        Event event = EventTemplateRegistry.get().buildCallEvent(this.callHook.getBehaviorOrdinal());
        MethodCall.handle(event, proxy, methodArgs);
    }

    void invokeReturn(Object proxy, Object ret, Object[] methodArgs) {
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = this.returnHook::toString;
        supplierArray[1] = this.returnHook::getMethodEvent;
        supplierArray[2] = () -> ret != null ? ret.toString() : "void";
        logger.trace("returnHook: {}, method event: {}, ret: {}", supplierArray);
        Event event = EventTemplateRegistry.get().buildReturnEvent(this.returnHook.getBehaviorOrdinal());
        MethodReturn.handle(event, proxy, ret, methodArgs);
    }

    void invokeExc(Object proxy, Throwable exc, Object[] methodArgs) {
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = this.excHook::toString;
        supplierArray[1] = this.excHook::getMethodEvent;
        logger.trace("excHook: {}, method event: {}", supplierArray);
        Event event = EventTemplateRegistry.get().buildReturnEvent(this.excHook.getBehaviorOrdinal());
        MethodException.handle(event, proxy, exc, methodArgs);
    }
}

