/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.process.hooks.remoterecording;

import com.appland.appmap.process.hooks.remoterecording.RemoteRecordingRequest;
import com.appland.appmap.record.Recording;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;

public class HttpCoreRequest
implements RemoteRecordingRequest {
    private HttpRequest req;
    private HttpResponse res;

    HttpCoreRequest(HttpRequest req, HttpResponse res) {
        this.req = req;
        this.res = res;
    }

    @Override
    public String getRequestURI() {
        return this.req.getRequestLine().getUri();
    }

    @Override
    public String getMethod() {
        return this.req.getRequestLine().getMethod();
    }

    @Override
    public void setStatus(int status) {
        this.res.setStatusCode(status);
    }

    @Override
    public void writeJson(String responseJson) throws IOException {
        StringEntity entity = new StringEntity(responseJson);
        entity.setContentType("application/json");
        this.res.setEntity((HttpEntity)entity);
    }

    public String toString() {
        return "HttpCoreRequest, req: " + this.req + " res: " + this.res;
    }

    @Override
    public void writeRecording(Recording recording) throws IOException {
        InputStreamEntity entity = new InputStreamEntity(recording.asInputStream());
        entity.setContentType("application/json");
        this.res.setEntity((HttpEntity)entity);
    }
}

